package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.common.util.Md5Util;
import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfUserVo;

public class SysUserDAO extends SqlMapClientDaoSupport {

	/**
	 * 保存密码
	 * 
	 * @param userId
	 * @param loginPassWord
	 * @return
	 */
	public boolean savePassWord(String userId, String loginPassWord) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("userId", userId);
		String newPass = Md5Util.Build(loginPassWord);
		map.put("loginPassWord", newPass);
		super.getSqlMapClientTemplate().update("savePassWord", map);
		return true;
	}

    /**
     * 保存签名密码
     * @param userId
     * @param signPassword
     * @return
     */
    public boolean saveSignPassword(String userId, String signPassword) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        String newPass = Md5Util.Build(signPassword);
        map.put("loginPassWord", newPass);
        super.getSqlMapClientTemplate().update("saveSignPassword", map);
        return true;
    }

	/**
	 * 获取用户信息
	 * 
	 * @param userId
	 * @return
	 */
	public PfUserVo getUserVo(String userId) {
		return (PfUserVo) super.getSqlMapClientTemplate().queryForObject(
				"getUserVo", userId);
	}

	/**
	 * 获取角色信息
	 * 
	 * @param roleId
	 * @return
	 */
	public PfRoleVo getRoleVo(String roleId) {
		return (PfRoleVo) super.getSqlMapClientTemplate().queryForObject(
				"getRoleVo", roleId);
	}

	/**
	 * 获取部门信息
	 * 
	 * @param organId
	 * @return
	 */
	public PfOrganVo getOrganVo(String organId) {
		return (PfOrganVo) super.getSqlMapClientTemplate().queryForObject(
				"getOrganVo", organId);
	}

    public PfOrganVo getOrganVoByName(String organName) {
		return (PfOrganVo) super.getSqlMapClientTemplate().queryForObject("getOrganVoByName", organName);
	}

	/**
	 * 获取部门列表
	 * 
	 * @return
	 */
	public List<PfOrganVo> getOrganList() {
		return super.getSqlMapClientTemplate().queryForList("getOrganList");
	}
	
	/**
	 * 根据备注获取部门
	 * @return
	 */
	public List<PfOrganVo> getOrganListByRemark(String remark) {
		return super.getSqlMapClientTemplate().queryForList("getOrganListByRemark",remark);
	}
	
	/**
	 * 获取角色列表
	 * 
	 * @return
	 */
	public List<PfRoleVo> getRoleList() {
		return super.getSqlMapClientTemplate().queryForList("getRoleList");
	}

	/**
	 * 获取一个用户的地区编码 用户的地区编码通过部门获取，如果有多个部门获取最小的地区编码
	 * 
	 * @param userId
	 * @return
	 */
	public String getUserRegionCode(String userId) {
		return (String) super.getSqlMapClientTemplate().queryForObject(
				"getUserRegionCode", userId);
	}

	/**
	 * 一个用户所在的部门
	 * 
	 * @param userId
	 * @return
	 */
	public List<PfOrganVo> getOrganListByUser(String userId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getOrganListByUser", userId);
	}

	/**
	 * 获取一个用户所在的角色
	 * 
	 * @param userId
	 * @return
	 */
	public List<PfRoleVo> getRoleListByUser(String userId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getRoleListByUser", userId);
	}

	/**
	 * 获取一个部门中所有的用户
	 * 
	 * @param oragnId
	 * @return
	 */
    @Cacheable(value="UserCache",key="#oragnId+'UserListByOrganId'")
	public List<PfUserVo> getUserListByOragn(String oragnId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getUserListByOragn", oragnId);
	}

	/**
	 * 获取一个角色中所有的用户
	 * 
	 * @param roleId
	 * @return
	 */
	public List<PfUserVo> getUserListByRole(String roleId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getUserListByRole", roleId);
	}

	/**
	 * 获取所有的用户列表
	 * 
	 * @return
	 */
	public List<PfUserVo> getUserList() {
		return super.getSqlMapClientTemplate().queryForList("getUserList");
	}
    
	/**
	 * 编辑用户
	 * @param pfUserVo
	 */

	public void updateUser(PfUserVo pfUserVo){
		super.getSqlMapClientTemplate().update("updateUser",pfUserVo);
	}
	
	/**
	 * 从一个部门和一个角色中查询用户
	 * 
	 * @param roleId
	 * @param organId
	 * @return
	 */
	public List<PfUserVo> getUserListByRoleAndOrgan(String roleId,
			String organId) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("roleId", roleId);
		map.put("organId", organId);
		return super.getSqlMapClientTemplate().queryForList(
				"getUserListByRoleAndOrgan", map);
	}

    /**
     * 查询多个部门和角色下的人员
     * @param roleId
     * @param organList
     * @return
     */
    public List<PfUserVo> getUserListByRoleAndOrganIds(String roleId,List<String> organList){
        HashMap<String,Object> map = new HashMap<String,Object>();
        map.put("roleId",roleId);
        map.put("organIds",organList);

        return super.getSqlMapClientTemplate().queryForList("getUserListByRoleAndOrganIds",map);
    }

	public List<String> getUserListByRoleUser(String roleId, String userId) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("userId", userId);
		map.put("roleId", roleId);
		return super.getSqlMapClientTemplate().queryForList(
				"getUserListByRoleUser", map);
	}

	/**
	 * 通过登录用户，返回uservo
	 * 
	 * @param loginName
	 * @return
	 */
	public PfUserVo getUserByloginName(String loginName) {
		return (PfUserVo) super.getSqlMapClientTemplate().queryForObject(
				"getUserByloginName", loginName);
	}

	/**
	 * 查询多个人员所属角色
	 * 
	 * @param userIds
	 * @return
	 */
	public List<PfRoleVo> getRoleListByUsers(String userIds) {
		return super.getSqlMapClientTemplate().queryForList("getRoleListByUsers", userIds);
	}

	/**
	 * 查询一个人员所有代理人员的角色
	 * 
	 * @param userId
	 * @return
	 */
	public List<String> getRoleListByAgentUser(String userId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getRoleListByAgentUser", userId);
	}

	/**
	 * 获得所有用户
	 * @return
	 */
	public List<PfUserVo> getAllUsers(){
		return super.getSqlMapClientTemplate().queryForList("getAllUsers");
	}
	
	public void insertConfig(PfConfigVo vo) {
		super.getSqlMapClientTemplate().insert("insertconfig", vo);

	}

	public void saveConfig(PfConfigVo vo) {
		super.getSqlMapClientTemplate().update("updateconfig", vo);
	}


	public PfConfigVo getConfigVo(String userId) {
		PfConfigVo configVo = (PfConfigVo) super.getSqlMapClientTemplate()
				.queryForObject("queryconfig", userId);

		return configVo;
	}
	
	/**
	 * 根据部门名查找用户
	 * @return
	 */
	public List<PfUserVo> getUsersByOrganName(String orginName){
		return (List<PfUserVo>)super.getSqlMapClientTemplate().queryForList("getUsersByOrganName",orginName);
	}

    /**
	 * 获取有效用户代理人列表,指授权用户，不是委托用户
	 *
	 * @param userId
	 * @return
	 */
	public List<PfUserVo> getUserAgentList(String userId) {
		return super.getSqlMapClientTemplate().queryForList("getUserAgentList",userId);
	}
	

    /**
     * 获得有效任务代理信息列表
     * @param userId
     * @return
     */
    @SuppressWarnings("unchecked")
	public List<PfTaskAgentVo> getAgentUserList(String userId){
        return (List<PfTaskAgentVo>)super.getSqlMapClientTemplate().queryForList("getAgentUserList",userId);
    }
    
    /**
     * 获得所有任务代理信息列表
     * @return
     */
    @SuppressWarnings("unchecked")
	public List<PfTaskAgentVo> getAllAgentUserList(){
        return (List<PfTaskAgentVo>)super.getSqlMapClientTemplate().queryForList("getAllAgentUserList");
    }
    
	/**
	 * 增加任务代理
	 * @param pfTaskAgentVo
	 */
	public void insertTaskAgent(PfTaskAgentVo pfTaskAgentVo){
		super.getSqlMapClientTemplate().insert("insertTaskAgent", pfTaskAgentVo);
	}
	/**
	 * 更新任务代理
	 * @param pfTaskAgentVo
	 */
	public void updateTaskAgent(PfTaskAgentVo pfTaskAgentVo){
		super.getSqlMapClientTemplate().insert("updateTaskAgent", pfTaskAgentVo);
	}

    public List<PfTaskAgentVo> getTaskAgentListByUser(String userId){
        return (List<PfTaskAgentVo>)super.getSqlMapClientTemplate().queryForList("getTaskAgentListByUser",userId);
    }

	/**
	 * 更新任务代理
	 * @param taskAgentId
	 */
	public PfTaskAgentVo getTaskAgent(String taskAgentId){
	  return (PfTaskAgentVo) super.getSqlMapClientTemplate().queryForObject("getTaskAgent", taskAgentId);
	}
    /**
	 * 删除任务代理
	 * @param taskAgentId
	 */
	public void deleteTaskAgent(String taskAgentId){
		super.getSqlMapClientTemplate().delete("deleteTaskAgent",taskAgentId);
	}
	/**
	 * 终止任务代理
	 * @param taskAgentId
	 */
	public void stopTaskAgent(String taskAgentId){
		super.getSqlMapClientTemplate().update("stopTaskAgent",taskAgentId);
	}

    /**
     * 根据用户名查找用列表
     * @param userName
     */
    public List<PfUserVo> getUserVoListByUserName(String userName){
        return (List<PfUserVo>)super.getSqlMapClientTemplate().queryForList("getUserVoListByUserName",userName);
    }

    /**
     * 根据用户名模糊查找用列表
     * @param userName
     */
    public List<PfUserVo> getUserVoListByUserNameFuzzy(String userName){
        return (List<PfUserVo>)super.getSqlMapClientTemplate().queryForList("getUserVoListByUserNameFuzzy",userName);
    }

    /**
     * 根据角色的名称获取角色列表
     * @param roleName
     * @return
     */
    public List<PfRoleVo> getRoleVoListByRoleNameFuzzy(String roleName){
        return (List<PfRoleVo>)super.getSqlMapClientTemplate().queryForList("getRoleVoListByRoleNameFuzzy",roleName);
    }

    /**
     * 根据regionde获取部门列表
     * @param regionCode
     * @return
     */
    public List<PfOrganVo> getOrganListByRegionCode(String regionCode){
        return (List<PfOrganVo>)super.getSqlMapClientTemplate().queryForList("getOrganListByRegionCode",regionCode);
    }
}
