package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.EcSupervisorVo;

public class SysSupervisorDAO extends SqlMapClientDaoSupport {
	public List<EcSupervisorVo> getEcSupervisorVoList(){
		return super.getSqlMapClientTemplate().queryForList("getEcSupervisorVoList");
	}
	
	public List<EcSupervisorVo> queryEcSupervisorVoByExceIdAndExplanNull(String exceptionId){
		return super.getSqlMapClientTemplate().queryForList("queryEcSupervisorVoByExceIdAndExplanNull", exceptionId);
	}
	//保存督办信息 
	public EcSupervisorVo saveEcSupervisorVo(EcSupervisorVo supervisor) {
		return (EcSupervisorVo) super.getSqlMapClientTemplate().insert("saveEcSupervisorVo", supervisor);		
	}
	//根据异常ID 获得 督办信息
	public EcSupervisorVo queryEcSupervisorVoByExceptionId(String exceptionID){
		return (EcSupervisorVo) super.getSqlMapClientTemplate().queryForObject("queryEcSupervisorVoByExceptionId", exceptionID);
	}
	//更新督办信息
	public void updateEcSupervisorVo(HashMap map){
		super.getSqlMapClientTemplate().update("updateEcSupervisorVo",map);
	}
	/**
	 * 获取督办列表
	 * @param condition
	 * @return
	 */
	public List<HashMap> getSupervisorDetailList(HashMap condition) {
		return super.getSqlMapClientTemplate().queryForList("getSupervisorDetailList",condition);
	}
	/**
	 * 根据督办ID 获取督办信息
	 * @param condition
	 * @return
	 */
	public HashMap queryEcSupervisorById(HashMap condition){
		return (HashMap) super.getSqlMapClientTemplate().queryForObject("queryEcSupervisorById",condition);
	}
	
	/**
	 * 回复督办信息
	 * @param condition
	 * @return
	 */
	public int fillEcSuperExplain(EcSupervisorVo supervisorVo){
		return super.getSqlMapClientTemplate().update("fillEcSuperExplain", supervisorVo);
	}
	
	//保存 领导发送的督办信息
	public void saveEcSupervisorVoByLeader(HashMap map){
		super.getSqlMapClientTemplate().insert("saveEcSupervisorVoByLeader",map);
	}
	//根据项目ID 获得该项目下的所有督办信息
	public List<HashMap> statSupervisorByInstanceId(String instanceId){
		return super.getSqlMapClientTemplate().queryForList("statSupervisorByInstanceId",instanceId);
	}
	/**
	 * 更新异常督办解释
	 * @param supervisor
	 * @return
	 */
	public void updateSuperviseExplain(EcSupervisorVo supervisor){
		super.getSqlMapClientTemplate().update("updateSuperviseExplain",supervisor);
	}
	
	/**
	 * 获得工作流异常信息
	 * @param workflowInstanceId
	 * @return
	 */
	public List<HashMap> getExceptionInfo(String workflowInstanceId){
		return super.getSqlMapClientTemplate().queryForList("getExceptionInfo", workflowInstanceId);
	}
	
	/**
	 * 获得未回复的节点
	 * @param activityId
	 * @return
	 */
	public List<EcSupervisorVo> getUnansweredSupervisorVoListByActivityId(String activityId){
		return super.getSqlMapClientTemplate().queryForList("getUnansweredSupervisorVoListByActivityId",activityId);
	}
}
