package com.gtis.plat.dao;

import com.gtis.plat.vo.PfNewsVo;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class SysNewsDAO extends SqlMapClientDaoSupport {
	
	/**
	 * 插入新闻
	 * @param newsVo
	 * @return
	 */
	public void insertNews(PfNewsVo newsVo){
		super.getSqlMapClientTemplate().insert("insertNews",newsVo);
	}
	
	/**
	 * 更新新闻
	 * @param newsVo
	 * @return
	 */
	public void updateNews(PfNewsVo newsVo){
		super.getSqlMapClientTemplate().update("updateNews",newsVo);
	}
	
	/**
	 * 删除新闻
	 * @param newsId
	 */
	public void deleteNews(String newsId){
		super.getSqlMapClientTemplate().delete("deleteNews",newsId);
	}
	
	/**
	 * 获得新闻
	 * @param newsId
	 * @return
	 */
	public PfNewsVo getNewsById(String newsId){
		return (PfNewsVo) super.getSqlMapClientTemplate().queryForObject("getNewsById",newsId);
	}
	
	/**
	 * 获得新闻列表
	 * @return
	 */
    @SuppressWarnings("unchecked")
	public List<PfNewsVo> getNewsList(){
		return getSqlMapClientTemplate().queryForList("getNewsList1");
	}
	
	/**
	 * 获得新闻信息
	 * @param newsId
	 * @return
	 */
	public HashMap<String, Object> getNewsInfoById(String newsId){
		return (HashMap<String, Object>) super.getSqlMapClientTemplate().queryForObject("getNewsInfoById",newsId);
	}
}
