package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PfFormDefineVo;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.plat.vo.PFDynamicSignVo;


public class SysFormDao extends SqlMapClientDaoSupport {

	public PfFormDefineVo getFormDefine(String defineId) {
		PfFormDefineVo vo = (PfFormDefineVo) super.getSqlMapClientTemplate().queryForObject("queryform", defineId);
		return vo;
	}
	public PfFormDefineVo getFormDefineSimple(String defineId) {
		PfFormDefineVo vo = (PfFormDefineVo) super.getSqlMapClientTemplate().queryForObject("queryformsimple", defineId);
		return vo;
	}
	
	public PfUserSignVo getSignUserImage(String userId){
		return (PfUserSignVo)super.getSqlMapClientTemplate().queryForObject("getSignUserImage", userId);
	}
	
	public PfUserSignVo getSign(String signId){
		return (PfUserSignVo)super.getSqlMapClientTemplate().queryForObject("getSign", signId);
	}
	
	public void createSign(PfUserSignVo signVo){
		super.getSqlMapClientTemplate().insert("createSign",signVo);
	}
	
}
