package com.gtis.plat.dao;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SysCalendarDAO extends SqlMapClientDaoSupport {

    /**
     * 获取到查询时间段内的特殊日期，包括是周末的工作日和非周末的节假日
     * @param beginDate 查询时间段起始时间
     * @param endDate 查询时间段结束时间
     * @return
     */
    public List<Map> getSpecialDateList(Date beginDate,Date endDate){
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("beginDate",beginDate);
        param.put("endDate",endDate);
        return (List<Map>) super.getSqlMapClientTemplate().queryForList("querySpecialCalendar",param);
    }
    /**
     * 根据日期类型（工作日、节假日）获取到查询时间段内符合条件的日期列表
     * @param calType 日期类型，工作日还是节假日
     * @param beginDate 查询时间段起始时间
     * @param endDate 查询时间段结束时间
     * @return
     */
    public List<Date> getDateListByCalType(String calType,Date beginDate,Date endDate){
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("begin",beginDate);
        param.put("finish",endDate);
        param.put("type",calType);
        return super.getSqlMapClientTemplate().queryForList("getDateList",param);
    }

}
