package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import com.gtis.plat.vo.PfActivityVo;


public class SysActivityDAO extends SqlMapClientDaoSupport {

	public PfActivityVo queryActivityById(String activityId){
		return (PfActivityVo) super.getSqlMapClientTemplate().queryForObject("queryActivityById", activityId);
	}
	
	public void updateActivityBackCount(PfActivityVo activity){
		super.getSqlMapClientTemplate().update("updateActivityBackCount", activity);
	}
	
	public List<HashMap> queryActivityDetailInfoById(String workflowInstanceId){
		return super.getSqlMapClientTemplate().queryForList("queryActivityDetailInfoById",workflowInstanceId);
	}

    public PfActivityVo queryBeforeBackActivityById(String activityId){
        //可能是一个列表，返回第一个
        List obj=super.getSqlMapClientTemplate().queryForList("queryBeforeBackActivityById", activityId);
        if (obj!=null && obj.size()>0)
            return (PfActivityVo)obj.get(0);
        else
            return null;
    }

    /**
     * 获取一个项目正在办理的活动
     * @param wiid
     * @return
     */
    public List<PfActivityVo> queryActiveActivity(String wiid){
        return super.getSqlMapClientTemplate().queryForList("queryActiveActivity",wiid);
    }
}
