/*
 * Project: tdsc
 *
 * File: LogDAO.java
 *
 * LastModified: 2011-02-23 04:42:09
 *
 * Copyright (c) 2011 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.dao;


import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.Log;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class LogDAO extends SqlMapClientDaoSupport {

    public Log saveLog(Log log) {
        if (StringUtils.isBlank(log.getId()))
            log.setId(UUIDGenerator.generate());
        return (Log) super.getSqlMapClientTemplate().insert("insertlog", log);
    }

    public List statMonthLog(String startTime,String endTime,String action) {
        Map<String,String> param=new HashMap<String, String>();
        param.put("startTime",startTime);
        param.put("endTime",endTime);
        if (StringUtils.isNotBlank(action))
            param.put("ACTION",action);
        return  super.getSqlMapClientTemplate().queryForList("statMonthLog",param);
    }
//    public Page<Log> search(String field, String operate, String keyword, Date startTime, Date endTime, int number, int size) {
//        Params params = getParams();
//        if (StringUtils.isNotEmpty(keyword)) {
//            String condition = "";
//            if ("like".equals(operate)) {
//                condition = "like '%" + keyword + "%'";
//            } else {
//                condition = "= '" + keyword + "'";
//            }
//            if (StringUtils.isNotEmpty(field)) {
//                condition = field + " " + condition;
//            } else {
//                StringBuilder sb = new StringBuilder();
//                for (int i = 0; i < fields.length; i++) {
//                    sb.append(fields[i]).append(" ").append(condition);
//                    if (i != fields.length)
//                        sb.append("and ");
//                }
//                condition = sb.toString();
//            }
//            params.put("condition", condition);
//        }
//        if (startTime != null)
//            params.put("startTime", startTime);
//        if (endTime != null)
//            params.put("endTime", endTime);
//        return pageQuery(params, number, size);
//    }

    public void clearLog(Date startTime, Date endTime) {
        super.getSqlMapClientTemplate().delete("clearlog",
                new Params().put("startTime", startTime).put("endTime", endTime));
    }

    public class Params extends HashMap<String, Object> {
        public Params put(String key, Object value) {
            super.put(key, value);
            return this;
        }
    }
}
