package com.gtis.plat.aop;

import IceInternal.Ex;
import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.bean.WorkFlowEventBean;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2018/4/20
 * @description 工作流转发切面
 */
public class WorkflowTurnAspect {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowTurnAspect.class);

    private WorkFlowEventBean workflowPreTurnEvent;
    private WorkFlowEventBean workflowPostTurnEvent;

    public WorkFlowEventBean getWorkflowPreTurnEvent() {
        return workflowPreTurnEvent;
    }

    public void setWorkflowPreTurnEvent(WorkFlowEventBean workflowPreTurnEvent) {
        this.workflowPreTurnEvent = workflowPreTurnEvent;
    }

    public WorkFlowEventBean getWorkflowPostTurnEvent() {
        return workflowPostTurnEvent;
    }

    public void setWorkflowPostTurnEvent(WorkFlowEventBean workflowPostTurnEvent) {
        this.workflowPostTurnEvent = workflowPostTurnEvent;
    }

    public Object preHandle(ProceedingJoinPoint pjp, WorkFlowInfo info) throws Throwable{
        try {
            if(workflowPreTurnEvent.doWork(info)) {
                return pjp.proceed();
            }
        } catch (Throwable throwable) {
            logger.error("工作流转发前非事务处理发生错误",throwable);
            throw throwable;
        }
        return false;
    }
    public boolean postHandle(WorkFlowInfo info,boolean result) throws Exception {
        try {
            if(result) return workflowPostTurnEvent.doWork(info);
        } catch (Exception e) {
            logger.error("工作流转发完成后非事务处理发生错误",e);
            throw e;
        }
        return false;
    }
}
