package com.gtis.plat.aop;

import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.bean.WorkFlowEventBean;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2018/4/20
 * @description 工作流办结切面
 */
public class WorkflowEndAspect {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowEndAspect.class);

    private WorkFlowEventBean workflowPostEndEvent;

    private WorkFlowEventBean workflowPreEndEvent;

    public WorkFlowEventBean getWorkflowPostEndEvent() {
        return workflowPostEndEvent;
    }

    public void setWorkflowPostEndEvent(WorkFlowEventBean workflowPostEndEvent) {
        this.workflowPostEndEvent = workflowPostEndEvent;
    }

    public void setWorkflowPreEndEvent(WorkFlowEventBean workflowPreEndEvent) {
        this.workflowPreEndEvent = workflowPreEndEvent;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param info 流程对象
     * @return
     * @description 工作流办结之前的非事务处理
     */
    public Object preHandle(ProceedingJoinPoint pjp, WorkFlowInfo info) throws Throwable{
        try {
            if(workflowPreEndEvent.doWork(info)){
                return pjp.proceed();
            }
        } catch (Throwable throwable) {
            logger.error("工作流办结之前非事务处理发生错误",throwable);
            throw throwable;
        }
        return false;
    }
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param info 流程对象
     * @return
     * @description 工作流办结完成后的非事务处理
     */
    public boolean postHandle(WorkFlowInfo info,boolean result) throws Exception{
        try {
            if(result) workflowPostEndEvent.doWork(info);
        } catch (Exception e) {
            logger.error("工作流办结完成后非事务处理发生错误",e);
            throw e;
        }
        return false;
    }
}
