package com.gtis.plat.aop;

import IceInternal.Ex;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.bean.WorkFlowEventBean;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2018/4/20
 * @description 工作流删除切面
 */
public class WorkflowDelAspect {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDelAspect.class);

    private WorkFlowEventBean workflowPostDelEvent;
    private WorkFlowEventBean workflowPreDelEvent;

    public WorkFlowEventBean getWorkflowPostDelEvent() {
        return workflowPostDelEvent;
    }

    public void setWorkflowPostDelEvent(WorkFlowEventBean workflowPostDelEvent) {
        this.workflowPostDelEvent = workflowPostDelEvent;
    }

    public void setWorkflowPreDelEvent(WorkFlowEventBean workflowPreDelEvent) {
        this.workflowPreDelEvent = workflowPreDelEvent;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param info 流程对象
     * @return
     * @description 工作流删除前非事务处理
     */
    public Object preHandle(ProceedingJoinPoint pjp, WorkFlowInfo info) throws Throwable {
        try {
            if(workflowPreDelEvent.doWork(info)) {
                return pjp.proceed();
            }
        } catch (Throwable throwable) {
            logger.error("工作流删除前非事务处理发生错误",throwable);
            throw throwable;
        }
        return false;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2018/4/21
     * @param info 流程对象
     * @return
     * @description 工作流删除完成后非事务处理
     */
    public boolean postHandle(WorkFlowInfo info,boolean result) throws Exception {
        try {
            if(result) return workflowPostDelEvent.doWork(info);
        } catch (Exception e) {
            logger.error("工作流删除完成后非事务处理发生错误",e);
            throw e;
        }
        return false;
    }
}
