package com.gtis.plat.aop;




import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpSession;

import com.gtis.plat.service.AttendanceService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionStorage;
import com.gtis.web.SessionUtil;

import org.aspectj.lang.JoinPoint;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.context.SecurityContext;

public class GoWorkAspect{

	AttendanceService attendanceService;
	
    public AttendanceService getAttendanceService() {
		return attendanceService;
	}


	public void setAttendanceService(AttendanceService attendanceService) {
		this.attendanceService = attendanceService;
	}
	

	/**
     * szx 上班打卡
     *
     * @param jp
     */
    public void loginAfter(JoinPoint jp, Object userInfo) {
        UserInfo user = (UserInfo) userInfo;
        attendanceService.goWork(user.getUsername());
    }
    /**
     * szx 下班打卡
     *
     * @param jp
     */
    public void logoutAfter(JoinPoint jp) {
        //UserInfo user = (UserInfo) userInfo;
        attendanceService.goOffWork(SessionUtil.getCurrentUser().getUsername());
    }



}
