package com.gtis.dform;

import com.gtis.plat.service.SysFormService;
import com.gtis.plat.vo.PfFormDefineVo;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import java.io.*;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:jibo1024@gmail.com">boji</a>
 * @version V1.0, ${Date}
 */
public class DFormTemplateLoader implements TemplateLoader {
    SysFormService formService;

    public void setFormService(SysFormService formService) {
        this.formService = formService;
    }

    public Object findTemplateSource(String s) throws IOException {
        PfFormDefineVo formDefineVo=formService.getFormDefine(s);
        return formDefineVo;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public long getLastModified(Object templateSource) {
        PfFormDefineVo formDefineVo=(PfFormDefineVo)templateSource;
        Date createTime=formDefineVo.getCreateTime();
        return createTime.getTime();
    }

    public Reader getReader(Object templateSource, String encodeType) throws IOException {
        PfFormDefineVo formDefineVo=(PfFormDefineVo)templateSource;
        String result=formDefineVo.getDefinitionXlst();
        InputStream is = new ByteArrayInputStream(result.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return br;  
    }

    public void closeTemplateSource(Object o) throws IOException {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    
}
