package com.gtis.config.dao;

import cn.gtmap.config.entity.PfUser;
import cn.gtmap.config.entity.PfUserRoleRel;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class PfUserRoleRelDao extends SqlMapClientDaoSupport {
	public PfUserRoleRel findById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("URR_ID",id);
			return (PfUserRoleRel) super.getSqlMapClientTemplate().queryForObject("get_CONFIG_PF_USER_ROLE_REL", param);
		}
		return null;
	}

	public List<PfUserRoleRel> findListByParam(HashMap param){
		return (List<PfUserRoleRel>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_USER_ROLE_REL", param);
	}

	public void insert(PfUserRoleRel obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUrrId()) && StringUtils.isNotBlank(obj.getUserId()) && StringUtils.isNotBlank(obj.getRoleId())){
			super.getSqlMapClientTemplate().insert("insert_CONFIG_PF_USER_ROLE_REL",obj);
		}
	}

	public void deleteById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("URR_ID",id);
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_ROLE_REL",param);
		}
	}

	public void deleteByParam(HashMap param){
		if (param != null && param.entrySet().size() > 0){
			if (StringUtils.isNotBlank(MapUtils.getString(param,"ROLE_ID"))
					|| StringUtils.isNotBlank(MapUtils.getString(param,"USER_ID"))
					|| StringUtils.isNotBlank(MapUtils.getString(param,"URR_ID"))){
				super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_ROLE_REL",param);
			}
		}
	}

	public List<PfUser> findPfUserListByRole(HashMap param){
		if (param != null && param.entrySet().size() > 0 && StringUtils.isNotBlank(MapUtils.getString(param,"ROLE_ID"))){
			return (List<PfUser>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_USER_BYROLE", param);
		}
		return null;
	}
	public void deletePfUserByRoleId(String id){
		if (StringUtils.isNotBlank(id)){
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_BYROLE",id);
		}
	}
}
