package com.gtis.config.dao;

import cn.gtmap.config.entity.PfUser;
import cn.gtmap.config.entity.PfUserOrganRel;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class PfUserOrganRelDao extends SqlMapClientDaoSupport {
	public PfUserOrganRel findById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("UDR_ID",id);
			return (PfUserOrganRel) super.getSqlMapClientTemplate().queryForObject("get_CONFIG_PF_USER_ORGAN_REL", param);
		}
		return null;
	}

	public List<PfUserOrganRel> findListByParam(HashMap param){
		return (List<PfUserOrganRel>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_USER_ORGAN_REL", param);
	}

	public void insert(PfUserOrganRel obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUdrId()) && StringUtils.isNotBlank(obj.getUserId()) && StringUtils.isNotBlank(obj.getOrganId())){
			super.getSqlMapClientTemplate().insert("insert_CONFIG_PF_USER_ORGAN_REL",obj);
		}
	}

	public void deleteById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("UDR_ID",id);
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_ORGAN_REL",param);
		}
	}

	public void deleteByParam(HashMap param){
		if (param != null && param.entrySet().size() > 0){
			if (StringUtils.isNotBlank(MapUtils.getString(param,"ORGAN_ID"))
					|| StringUtils.isNotBlank(MapUtils.getString(param,"USER_ID"))
					|| StringUtils.isNotBlank(MapUtils.getString(param,"UDR_ID"))){
				super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_ORGAN_REL",param);
			}
		}
	}

	public List<PfUser> findPfUserListByOrgan(HashMap param){
		if (param != null && param.entrySet().size() > 0 && StringUtils.isNotBlank(MapUtils.getString(param,"ORGAN_ID"))){
			return (List<PfUser>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_USER_BYORGAN", param);
		}
		return null;
	}
	public void deletePfUserByOrganId(String id){
		if (StringUtils.isNotBlank(id)){
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER_BYORGAN",id);
		}
	}
}
