package com.gtis.config.dao;

import com.gtis.common.util.Md5Util;
import cn.gtmap.config.entity.PfUser;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class PfUserDao extends SqlMapClientDaoSupport {
	public PfUser findById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("USER_ID",id);
			return (PfUser) super.getSqlMapClientTemplate().queryForObject("get_CONFIG_PF_USER", param);
		}
		return null;
	}

	public PfUser findByParam(HashMap param){
		List<PfUser> list = findListByParam(param);
		if (list != null && !list.isEmpty()){
			return list.get(0);
		}
		return null;
	}

	public List<PfUser> findListByParam(HashMap param){
		return (List<PfUser>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_USER", param);
	}

	public void insert(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId())){
			super.getSqlMapClientTemplate().insert("insert_CONFIG_PF_USER",obj);
		}
	}
	public void update(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_USER",obj);
		}
	}
	public void updateLoginPassword(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId()) && StringUtils.isNotBlank(obj.getLoginPassword())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_USER_LOGIN_PASSWORD",obj);
		}
	}
	public void updateSignPassword(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_USER_SIGN_PASSWORD",obj);
		}
	}
	public void updatePhoto(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_USER_PHOTO",obj);
		}
	}
	public void updateSign(PfUser obj){
		if (obj != null && StringUtils.isNotBlank(obj.getUserId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_USER_SIGN",obj);
		}
	}

	public void deleteById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("USER_ID",id);
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_USER",param);
		}
	}
}
