package com.gtis.config.dao;

import cn.gtmap.config.entity.PfRole;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class PfRoleDao extends SqlMapClientDaoSupport {
	public PfRole findById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("ROLE_ID",id);
			return (PfRole) super.getSqlMapClientTemplate().queryForObject("get_CONFIG_PF_ROLE", param);
		}
		return null;
	}

	public PfRole findByParam(HashMap param){
		List<PfRole> list = findListByParam(param);
		if (list != null && !list.isEmpty()){
			return list.get(0);
		}
		return null;
	}

	public List<PfRole> findListByParam(HashMap param){
		return (List<PfRole>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_ROLE", param);
	}

	public void insert(PfRole obj){
		if (obj != null && StringUtils.isNotBlank(obj.getRoleId())){
			super.getSqlMapClientTemplate().insert("insert_CONFIG_PF_ROLE",obj);
		}
	}
	public void update(PfRole obj){
		if (obj != null && StringUtils.isNotBlank(obj.getRoleId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_ROLE",obj);
		}
	}

	public void deleteById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("ROLE_ID",id);
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_ROLE",param);
		}
	}
}
