package com.gtis.config.dao;

import cn.gtmap.config.entity.PfOrgan;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class PfOrganDao extends SqlMapClientDaoSupport {
	public PfOrgan findById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("ORGAN_ID",id);
			return (PfOrgan) super.getSqlMapClientTemplate().queryForObject("get_CONFIG_PF_ORGAN", param);
		}
		return null;
	}

	public PfOrgan findByParam(HashMap param){
		List<PfOrgan> list = findListByParam(param);
		if (list != null && !list.isEmpty()){
			return list.get(0);
		}
		return null;
	}

	public List<PfOrgan> findListByParam(HashMap param){
		return (List<PfOrgan>) super.getSqlMapClientTemplate().queryForList("get_CONFIG_PF_ORGAN", param);
	}

	public void insert(PfOrgan obj){
		if (obj != null && StringUtils.isNotBlank(obj.getOrganId())){
			super.getSqlMapClientTemplate().insert("insert_CONFIG_PF_ORGAN",obj);
		}
	}
	public void update(PfOrgan obj){
		if (obj != null && StringUtils.isNotBlank(obj.getOrganId())){
			super.getSqlMapClientTemplate().update("update_CONFIG_PF_ORGAN",obj);
		}
	}

	public void deleteById(String id){
		if (StringUtils.isNotBlank(id)){
			HashMap param = new HashMap();
			param.put("ORGAN_ID",id);
			super.getSqlMapClientTemplate().delete("delete_CONFIG_PF_ORGAN",param);
		}
	}
}
