
/**
 * serialize object
 * @returns {{}}
 */
$.fn.serializeObject = function () {
    var o = {};
    var a = this.serializeArray();
    $.each(a, function () {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};

var cbSelModel = Ext.create('Ext.selection.CheckboxModel',{checkOnly:true});

/**
 * 地图定位样式
 * @param value
 * @param p
 * @param r
 */
var mapRenderer = function (value, p, r) {
    return "<div style='text-align:center;width:100%'><span onclick='javascript:mapLocation(\"" + r.data.objectId + "\")' class='glyphicon glyphicon-globe green'></span></div>";
};

/**
 *  格式化时间显示样式
 * @param val
 */
function dateFormat(val) {
    if (val) {
        if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
            return Ext.util.Format.date(new Date(val), "Y年m月d日");
        else
            return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
    }
    else return "";
}

/**
 * 打开地图窗口
 * @param url
 */
function showMapWin(url) {
    var w_width = screen.availWidth - 10;
    var w_height = screen.availHeight - 32;
    window.open(url, "_map", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
};
/**
 * 打开地图窗口 ext
 * @param url
 */
function showMapWinExt(url){

    var win = Ext.create('Ext.window.Window', {
        title:'地图定位',
        height:700,
        width:920,
        modal:true,
        layout:'fit',
        items:{
            html:'<iframe src="' + url + '" style="border: 0px;width:100%,height:100%"></iframe>'
        }
    });
    win.show();
}

//将时间转化为 2011-08-20 00:00:00 格式
//解决Ext4的formPanel通过grid的store查询问题
function submitDateFormat(value){
    if(null != value){
        return Ext.Date.format(new Date(value),'Y-m-d');
    }else{
        return null;
    }
}


/**
 * 导出excel
 * @param type
 * @param condition
 * @param fileName
 */
function exportExcel(type,condition,fileName){

    var url = '/emapserver/ledger/ledger!export.action';
    var tempForm = document.createElement("form");
    tempForm.method = "post";
    tempForm.action = url;
    var hideInput1 = document.createElement("input");
    hideInput1.type = "hidden";
    hideInput1.name = "type"
    hideInput1.value = type;
    var hideInput2 = document.createElement("input");
    hideInput2.type = "hidden";
    hideInput2.name = "fileName"
    hideInput2.value = fileName;
    var hideInput3 = document.createElement("input");
    hideInput3.type = "hidden";
    hideInput3.name = "condition"
    hideInput3.value = condition;
    tempForm.appendChild(hideInput1);
    if (fileName != null && fileName != "null" && fileName != "")
        tempForm.appendChild(hideInput2);
    tempForm.appendChild(hideInput3);

    document.body.appendChild(tempForm);
    tempForm.submit();
    document.body.removeChild(tempForm);
}

/**
 * 导出shp包
 * @param type
 * @param condition
 */
function exportShp(type,condition){


    var url = '/emapserver/ledger/ledger!exportShp.action';
    var tempForm = document.createElement("form");
    tempForm.method = "post";
    tempForm.action = url;
    var hideInput1 = document.createElement("input");
    hideInput1.type = "hidden";
    hideInput1.name = "type"
    hideInput1.value = type;
    var hideInput3 = document.createElement("input");
    hideInput3.type = "hidden";
    hideInput3.name = "condition"
    hideInput3.value = condition;
    tempForm.appendChild(hideInput1);
    tempForm.appendChild(hideInput3);

    document.body.appendChild(tempForm);
    tempForm.submit();
    document.body.removeChild(tempForm);

}

/**
 *  页面过滤查询并高亮结果
 */
function onSearch(gridPanel) {
    var count = 0;
    gridPanel.view.refresh();

    gridPanel.searchValue = gridPanel.down('textfield[name=searchField]').getValue();  //得到要搜索的值value
    gridPanel.indexes = [];
    gridPanel.currentIndex = null;
    gridPanel.searchRegExp = null;
    gridPanel.caseSensitive = true;
    gridPanel.regExpMode = false;
    gridPanel.matchCls = 'x-livesearch-match';
    gridPanel.tagsRe = /<[^>]*>/gm;
    gridPanel.tagsProtect='\x0f';
    if (gridPanel.searchValue !== null) {

        gridPanel.searchRegExp = new RegExp(gridPanel.searchValue, 'g' + (gridPanel.caseSensitive ? '' : 'i'));

        gridPanel.store.each(function (record, idx) {
            var td = Ext.fly(gridPanel.view.getNode(idx)).down('td'),
                cell, matches, cellHTML;
            while (td) {
                cell = td.down('.x-grid-cell-inner');
                matches = cell.dom.innerHTML.match(gridPanel.tagsRe);
                cellHTML = cell.dom.innerHTML.replace(gridPanel.tagsRe, gridPanel.tagsProtect);
                cellHTML = cellHTML.replace(/&nbsp;/ig, "");    //替换&nbsp；
                cellHTML = cellHTML.replace(gridPanel.searchRegExp, function (m) {
                    count += 1;
                    if (Ext.Array.indexOf(gridPanel.indexes, idx) === -1) {
                        gridPanel.indexes.push(idx);
                    }
                    if (gridPanel.currentIndex === null) {
                        gridPanel.currentIndex = idx;
                    }
                    return '<span class="' + gridPanel.matchCls + '">' + m + '</span>';
                });
                Ext.each(matches, function (match) {
                    cellHTML = cellHTML.replace(gridPanel.tagsProtect, match);
                });
                cell.dom.innerHTML = cellHTML;
                td = td.next();
            }
        }, gridPanel);

//        if (gridPanel.currentIndex !== null) {
//            gridPanel.getSelectionModel().select(gridPanel.currentIndex);
////            gridPanel.statusBar.setStatus({
////                text: count + ' matche(s) found.',
////                iconCls: 'x-status-valid'
////            });
//        }
    }

        if (me.currentIndex === null) {
            me.getSelectionModel().deselectAll();
        }
        gridPanel.down('textfield[name=searchField]').focus();

}

/**
 * 条件检索模型
 */
Ext.define('fieldModel', {
    extend:'Ext.data.Model',
    fields:['name', 'field', 'title', 'condition', 'value']
});

Ext.define('gtis.store.FieldStore', {
    extend:'Ext.data.Store',
    config:{
        model:'fieldModel',
        autoLoad:true,
        proxy:{
            type:'ajax',
            url:'',
            reader:{
                type:'json'
            }
        }
    },
    constructor:function (config) {
        this.config.proxy.url = config.url;
        this.callParent(arguments);
        this.initConfig(config);
    }
});

/**
 * 查询右侧拖拉窗体Store
 */
Ext.define('gtis.store.SelectedFStore', {
    extend:'Ext.data.Store',
    config:{
        model:'fieldModel'
    }
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit:1
});

/**
 *
 */
Ext.define('gtis.panel.LeftDragPanel', {
    extend:'Ext.grid.Panel',
    bodyStyle:'margin:0px 20px 0px 0px',
    viewConfig:{
        plugins:{
            ptype:'gridviewdragdrop',
            dragGroup:'leftGridGroup',
            dropGroup:'rightGroup'
        },
        listeners:{
            drop:function (node, data, dropRect, dropPos) {
                //
                debugger;
            }
        }
    },
    columns:[
        {
            text:'待检索字段',
            dataIndex:'title',
            width:140
        }
    ],
    multiSelect:false,
    store:null,
    constructor:function (config) {
        debugger;
        this.store = config.store;
        this.callParent(arguments);
        this.initConfig(this.config);
    }
});

/**
 *
 */
Ext.define('gtis.panel.RightDropPanel', {
    extend:'Ext.grid.Panel',
    bodyStyle:{
        padding:'0px 2px 0px 2px'
    },
    viewConfig:{
        plugins:{
            ptype:'gridviewdragdrop',
            dragGroup:'rightGroup',
            dropGroup:'leftGridGroup'
        },
        listeners:{
            drop:function (node, data, dropRect, dropPos) {
            }
        }
    },
    columns:[
        {
            header:'已选字段',
            width:140,
            dataIndex:'title'
        },
        {
            header:'条件',
            dataIndex:'condition',
            width:100,
            editor:new Ext.form.field.ComboBox({
                typeAhead:true,
                triggerAction:'all',
                selectOnTab:true,
                store:[
                    [ 'like', '类似'],
                    [ '=', '等于'],
                    [ '>', '大于'],
                    [ '<', '小于'],
                    [ '!=', '不等于']
                ],
                lazyRender:true,
                listClass:'x-combo-list-small'
            })
        },
        {
            header:'值',
            dataIndex:'value',
            width:140,
            editor:{
                allowBlank:true
            }
        }
    ],
    selModel:{
        selType:'cellmodel'
    },
    multiSelect:false,
    store:null,
    plugins:[
        cellEditing
    ],
    constructor:function (config) {
        debugger;
        this.store = config.store;
        this.callParent(arguments);
        this.initConfig(this.config);
    }
});


/**
 * 添加检索条件
 */
function onAddCondition(e) {
    var conWins = Ext.create("Ext.window.Window", {
        iconCls:'ex_search',
        title:'条件检索',
        modal:true,
        headerPosition:'top',
        plain:true,
        closable:true,
        closeAction:'hide',
        width:560,
        height:400,
        layout:{
            type:'hbox',
            align:'stretch'
        },
        bodyStyle:{
            padding:'5px 5px 10px 5px;'
        },
        items:[
            leftGrid ,
            rightDrop
        ],
        bbar:[
            '->',
            {
                text:'确定',
                handler:function () {
                    debugger;
                    var json = Ext.encode(Ext.pluck(selectedStore.data.items, 'data'));
                    store.load({
                        params:{
                            condition:json
                        }
                    });
                    conWins.close();
                }
            }
        ]

    });
    conWins.show();
}

/**
 * 时间上加上一段天数
 * @param date
 * @param days
 * @returns {*}
 */
function addDays(date,days){

    if (date instanceof Date)
        return new Date(date + days * 24 * 60 * 60 * 1000);
    else if (date instanceof String) {
        var nd = new Date(date);
        nd = nd.valueOf();
        nd = nd + days * 24 * 60 * 60 * 1000;
        nd = new Date(nd);
        return nd;
    }else return null;
    //alert(nd.getFullYear() + "年" + (nd.getMonth() + 1) + "月" + nd.getDate() + "日");
//    var y = nd.getFullYear();
//    var m = nd.getMonth()+1;
//    var d = nd.getDate();
//    if(m <= 9) m = "0"+m;
//    if(d <= 9) d = "0"+d;
//    var cdate = y+"-"+m+"-"+d;
}
/**
 * 2个时间的差值
 * @param d1
 * @param d2
 * @returns {*}
 */
function dateDiff(d1,d2){

    if (d1 instanceof Date && d2 instanceof Date)
        return d1.getTime() - d2.getTime();
    else
    {
        var nd1 = new Date(d1);
        var nd2 = new Date(d2);
        return nd1.getTime()-nd2.getTime();
    }
    return null;
}




//    Highcharts.theme = {
//    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'],
//    chart: {
//        backgroundColor: {
//            linearGradient: { x1: 0, y1: 0, x2: 1, y2: 1 },
//            stops: [
//                [0, 'rgb(255, 255, 255)'],
//                [1, 'rgb(240, 240, 255)']
//            ]
//        },
//        borderWidth: 2,
//        plotBackgroundColor: 'rgba(255, 255, 255, .9)',
//        plotShadow: true,
//        plotBorderWidth: 1
//    },
//    title: {
//        style: {
//            color: '#000',
//            font: 'bold 16px "Trebuchet MS", Verdana, sans-serif'
//        }
//    },
//    subtitle: {
//        style: {
//            color: '#666666',
//            font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'
//        }
//    },
//    xAxis: {
//        gridLineWidth: 1,
//        lineColor: '#000',
//        tickColor: '#000',
//        labels: {
//            style: {
//                color: '#000',
//                font: '11px Trebuchet MS, Verdana, sans-serif'
//            }
//        },
//        title: {
//            style: {
//                color: '#333',
//                fontWeight: 'bold',
//                fontSize: '12px',
//                fontFamily: 'Trebuchet MS, Verdana, sans-serif'
//
//            }
//        }
//    },
//    yAxis: {
//        minorTickInterval: 'auto',
//        lineColor: '#000',
//        lineWidth: 1,
//        tickWidth: 1,
//        tickColor: '#000',
//        labels: {
//            style: {
//                color: '#000',
//                font: '11px Trebuchet MS, Verdana, sans-serif'
//            }
//        },
//        title: {
//            style: {
//                color: '#333',
//                fontWeight: 'bold',
//                fontSize: '12px',
//                fontFamily: 'Trebuchet MS, Verdana, sans-serif'
//            }
//        }
//    },
//    legend: {
//        itemStyle: {
//            font: '9pt Trebuchet MS, Verdana, sans-serif',
//            color: 'black'
//
//        },
//        itemHoverStyle: {
//            color: '#039'
//        },
//        itemHiddenStyle: {
//            color: 'gray'
//        }
//    },
//    labels: {
//        style: {
//            color: '#99b'
//        }
//    },
//
//    navigation: {
//        buttonOptions: {
//            theme: {
//                stroke: '#CCCCCC'
//            }
//        }
//    }
//};


