<@com.html title="抵押到期" import="jquery,bootstrap,highcharts,ext,base">
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            params.dydqsj = submitDateFormat(params.dydqsj);
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    djdk: JSON.stringify(params)
                },
                success: function (response,_s) {
                    var result = JSON.parse(response);
                    myMask.hide();
                    if(result.success)
                    {
                        alert(result.msg);
                    }else
                    {
                        alert(result.msg);
                    }
                    store.load();
                },
                failure: function (response, opts) {

                    myMask.hide();
                    alert(response);
                }
            });
        }
    });

    var typeStore =  Ext.create('Ext.data.Store',{
        fields: ['id','value'],
        data : [
            {id:"已经到期",value:"DYDQSJ - current_date < 0"},
            {id:"即将到期",value:"DYDQSJ - current_date >= 0 and DYDQSJ - current_date <= 30"}
        ]
    });

    var searchForm = new Ext.window.Window({
        frame:true,
        title: '融资抵押到期预警检索',
        bodyStyle:'padding:5px 5px 0',
        width: 350,
        defaultType: 'textfield',
        defaults: {
            anchor: '100%'
        },

        items:[{
            region: 'center',
            xtype: 'form',
            frame: true,
            defaultType: 'textfield',
            defaults: {
                anchor: '100%',
                width: '100%',
                labelSeparator: '：'
            },
            itemCls:'winFont',

            items: [
                {
                    fieldLabel: '到期提醒',
                    xtype: 'combobox',
                    name: 'dqtx',
                    valueField: 'value',
                    displayField: 'id',
                    store:typeStore
                    //            allowBlank:false
                },{
                    fieldLabel: '单位名称',
                    name: 'dwmc1'
                },{
                    fieldLabel: '土地坐落',
                    name: 'tdzl'
                }, {
                    fieldLabel: '土地证号',
                    name: 'tdzh'
                }
            ]
        }],

        buttons: [{
            text: '搜索',
            handler:function(){
                debugger;
                var form = searchForm.items.items[0].getForm();
                var param = form.getValues();
                var map = {};
                map.condition = Ext.encode(new Array(param));
                store.proxy.extraParams = map;
                searchForm.hide();
                store.load();
                Ext.getCmp("clearBtn").show();
            }
        },{
            text: '取消',
            handler:function(){
                searchForm.hide();
            }
        }]
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-108)/20);
    var minHeight = Ext.getBody().getViewSize().height-30;
    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'djdkModel',
            remoteSort:true,
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:true,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'土地证号',dataIndex:'tdzh',width:200},
                {text:'图形定位', width:80, renderer:mapRenderer,sortable:false},
                {text:'到期提醒',dataIndex:'dydqsj',width:80,renderer:warnMe},
                {text:'单位名称', dataIndex:'dwmc1', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {text:'是否注销', dataIndex:'sfzx', width:100,renderer:zxRenderer},
                {id:'tip1',text:'抵押类型', dataIndex:'dylx', width:100,
                    field:{
                        xtype:'textfield'
                    }},
//                {text:'抵押金额', dataIndex:'dyje', width:100,
//                field:{
//                    xtype:'textfield'
//                }},
                {text:'抵押到期时间', dataIndex:'dydqsj', width:120,renderer:dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
//                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }
                }
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'idleLandGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                            }
//                        }
//                    },
                    {
                        text:'搜索',
                        xtype:'button',
                        handler:function(){
//                            alert("搜索");
                            debugger;
                            searchForm.show();
                        }
                    },
                    {
                        id:"clearBtn",
                        text:'清除',
                        xtype:'button',
                        hidden:true,
                        handler:function(){
//                            alert("搜索");
                            debugger;
                            store.proxy.extraParams= null;
                            store.load();
                            Ext.getCmp("clearBtn").hide();
                        }
                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: [rowEditing]

        });

        Ext.create('Ext.tip.ToolTip', {
            target:gridPanel.getView().el,
            delegate: gridPanel.getView().itemSelector,
            trackMouse: true,
            html: '双击编辑'
        });

    });
    /**
     * 融资抵押到期的预警
     * @param val
     */
    function warnMe(val,p,model){
        debugger;
        if(val)
        {
            var date;
            var sfzx = model.data.sfzx;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                var diffTime = dateDiff(date, current_date);
                if (diffTime <= 0 && sfzx==0)   //sfzx==0 未注销的
                return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>已经到期";
                if (diffTime > 0 && diffTime <= 30 * 24 * 60 * 60 * 1000 && sfzx==0)
                    return "<span class=\"glyphicon glyphicon glyphicon-warning-sign red\"></span>即将到期";
            }
        }
        return "";
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

    /**
     * 是否注销
     * @param val
     * @returns {string}
     */
    function zxRenderer(val) {
        if (val == 1)
            return '是';
        else
            return '否';
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>