<@com.html title="黑名单企业管理" import="jquery,bootstrap,highcharts,ext,base">

<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'illegalRowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    gddk: JSON.stringify(params)
                },
                success: function (response,_s) {
                    var result = JSON.parse(response);
                    myMask.hide();
                    if(result.success)
                    {
                        alert(result.msg);
                    }else
                    {
                        alert(result.msg);
                    }
                    store.load();
                },
                failure: function (response, opts) {

                    myMask.hide();
                    alert(response);
                }
            });
        }
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-118)/20);
    var minHeight = Ext.getBody().getViewSize().height-30;

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'gddkModel',
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'预警', width:50, renderer:warnRenderer,sortable:false},
                {text:'地块编号', dataIndex:'dkbh', width:100},
                {text:'项目名称', dataIndex:'xmmc', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {text:'用途', dataIndex:'yt', width:100},
                {text:'开工时间', dataIndex:'sjkgsj', width:120,renderer:dateFormat},
                {text:'竣工时间', dataIndex:'sjjgsj', width:120,renderer:dateFormat},
                {text:'约定开工时间', dataIndex:'ydkgsj', width:120,renderer:dateFormat},
                {text:'约定竣工时间', dataIndex:'ydjgsj', width:120,renderer:dateFormat},
                {text:'是否分期',dataIndex:'sffq',width:100,renderer:fqRenderer},
                {text:'是否缴纳', dataIndex:'sfjn', width:100,renderer:fqRenderer},
                {text:'应缴出让金', dataIndex:'sjcrj', width:100},
                {text:'已缴出让金', dataIndex:'yjcrj', width:100},
                {text:'出让金到期时间', dataIndex:'crjsj', width:120,renderer:dateFormat},
                {
                    text:'一期应缴出让金',
                    dataIndex:'yjcrj1',
                    width:100,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'一期应缴时间',
                    dataIndex:'crjsj1',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'一期实际缴纳出让金',
                    dataIndex:'sjcrj1',
                    width:100,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'一期实际缴纳时间',
                    dataIndex:'sjcrjsj1',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'二期应缴出让金',
                    dataIndex:'yjcrj2',
                    width:120,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'二期应缴时间',
                    dataIndex:'crjsj2',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'二期实际缴纳出让金',
                    dataIndex:'sjcrj2',
                    width:100,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'二期实际缴纳时间',
                    dataIndex:'sjcrjsj2',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'三期应缴出让金',
                    dataIndex:'yjcrj3',
                    width:100,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'三期应缴时间',
                    dataIndex:'crjsj3',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'三期实际缴纳出让金',
                    dataIndex:'sjcrj3',
                    width:100,
                    field:
                    {
                        xtype:'textfield'
//                        vtype:'area'
                    }
                },
                {
                    text:'三期实际缴纳时间',
                    dataIndex:'sjcrjsj3',
                    width:120,
                    renderer:dateFormat,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                }
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:false,
                trackOver:false,
                id:'myGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
//            plugins:[rowEditing]

        });

//        Ext.create('Ext.tip.ToolTip', {
//            target:gridPanel.getView().el,
//            delegate: gridPanel.getView().itemSelector,
//            trackMouse: true,
//            html: '双击编辑'
//        });

    });


    /**
     *
     * 黑名单预警
     * */
    function warnRenderer(value, p, r){
        var record = r.data;
        var current_date = new Date();
        var sffq = record.sffq;
        var yjcrj;//已缴出让金
        var crj=record.yjcrj;//应缴出让金
        var sjcrj=record.sjcrj;//实缴出让金
        var crjsj = getDate(record.crjsj);//出让金到期时间
        var sjcrjsj = getDate(record.sjcrjsj);//实际缴纳出让金时间


        if(sffq==1){    //分期
            if((record.sjcrj1 + record.sjcrj2 + record.sjcrj3)<(record.yjcrj1 + record.yjcrj2 + record.yjcrj3)
                    &&(getDate(record.crjsj1),getDate(record.sjcrjsj1)<0) || dateDiff(getDate(record.crjsj2),getDate(record.sjcrjsj2))<0 || dateDiff(getDate(record.crjsj3),getDate(record.sjcrjsj3))<0){
                return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-warning-sign' style='color: red' title='超过约定应缴时间未缴纳完全的'></span></div>";
            }

            if(dateDiff(getDate(record.crjsj1),getDate(record.sjcrjsj1)<0) || dateDiff(getDate(record.crjsj2),getDate(record.sjcrjsj2))<0 || dateDiff(getDate(record.crjsj3),getDate(record.sjcrjsj3))<0){
                return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-warning-sign' style='color: green' title='实际缴纳时间晚于约定缴纳时间的'></span></div>";
            }
        }else{           //不分期
            if(sjcrj<crj && dateDiff(crjsj, sjcrjsj)<0){
                return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-warning-sign' style='color: red' title='超过约定应缴时间未缴纳完全的'></span></div>";
            }

            if(dateDiff(crjsj,sjcrjsj)<0){
                return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-warning-sign' style='color: green' title='实际缴纳时间晚于约定缴纳时间的'></span></div>";
            }
        }
    }

    function getDate(val){
        if(!val)return null;
        if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
            return new Date(val)
        else
            return new Date(Date.parse(val.replace(/-/g, "/")));
    }

    /**
     * 2个时间的差值
     * @param d1
     * @param d2
     * @returns {*}
     */
    function dateDiff(d1,d2){

        if (d1 instanceof Date && d2 instanceof Date)
            return d1.getTime() - d2.getTime();
        else
        {
            var nd1 = new Date(d1);
            var nd2 = new Date(d2);
            return nd1.getTime()-nd2.getTime();
        }
        return null;
    }

    /**
     * 是否分期
     * @param val
     * @returns {string}
     */
    function fqRenderer(val) {
        if (val == 1)
            return '是';
        else
            return '否';
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>