<@com.html title="土地闲置预警" import="jquery,bootstrap,highcharts,ext,base">

<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox',
        'Ext.grid.*'
    ]);
//    var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
//        clicksToEdit: 2
//    });

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            params.sjkgsj = submitDateFormat(params.sjkgsj);
            params.sjjgsj = submitDateFormat(params.sjjgsj);
            if (params.sffq == false)
                params.sffq = 0;
            else
                params.sffq = 1;
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    gddk: JSON.stringify(params)
                },
                success: function (response,_s) {

                    var result = JSON.parse(response);
//                    changes.record.commit();
                    myMask.hide();
                    if(result.success)
                    {
                        store.load();
                        Ext.Msg.show({
                            title:'操作提示',
                            msg: result.msg,
                            buttons: Ext.Msg.YES,
                            icon: Ext.Msg.WARNING
                        });
                    }else
                    {
                        alert(result.msg);
                    }

                },
                failure: function (response, opts) {

                    myMask.hide();
                }
            });
        }
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-118)/20);
    var minHeight = Ext.getBody().getViewSize().height-30;

    function formatTime(date){
        return Ext.util.Format.date(date,'Y-m-d');
    }

    var typeStore =  Ext.create('Ext.data.Store',{
        fields: ['id','value'],
        data : [
            {id:"约定开工前一个月",value:"SJ_DG_SJ - current_date >=0 and SJ_DG_SJ - current_date  <= 30"},
            {id:"约定开工时间到约定竣工前一个月时间段内",value:"SJ_JG_SJ - current_date >= 0 and SJ_JG_SJ - current_date <= 30 and SJ_DG_SJ - current_date <= 0 "},
            {id:"约定竣工前一个月",value:"SJ_DG_SJ - current_date >= 0 && SJ_JG_SJ - current_date <= 30"},
            {id:"约定竣工后",value:" SJ_JG_SJ - current_date < 0"}
               ]
    });

    var searchForm = new Ext.window.Window({
        frame:true,
        title: '土地闲置预警查询',
        bodyStyle:'padding:5px 5px 0',
        width: 350,
        defaultType: 'textfield',
        defaults: {
            anchor: '100%'
        },


        items:[{
            region: 'center',
            xtype: 'form',
            frame: true,
            defaultType: 'textfield',
            defaults: {
            anchor: '100%',
            width: '100%',
            labelSeparator: '：'
            },
            itemCls:'winFont',

            items: [
                {
                    fieldLabel: '地块编号',
                    name: 'dkbh',
                    //            allowBlank:false
                },{
                    fieldLabel: '项目名称',
                    name: 'xmmc'
                },{
                    fieldLabel: '土地坐落',
                    name: 'tdzl'
                }, {
                    xtype: 'combobox',
                    fieldLabel: '预警类型',
                    name: 'yjlx',
                    valueField: 'value',
                    displayField: 'id',
                    store:typeStore
                }
            ]
        }],

        buttons: [{
            text: '搜索',
            handler:function(){
                debugger;
                var form = searchForm.items.items[0].getForm();
                var param = form.getValues();
                var map = {};
                map.condition = Ext.encode(new Array(param));
                store.proxy.extraParams = map;
                searchForm.hide();
                store.load();
                Ext.getCmp("clearBtn").show();
            }
        },{
            text: '取消',
            handler:function(){
                searchForm.hide();
            }
        }]
    });

    Ext.onReady(function(){

        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'gddkModel',
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100, hidden:true},
                {text:'图形定位', width:80, renderer:mapRenderer,sortable:false},
                {text:'预警', width:50, renderer:warnRenderer,sortable:false},
//                {text:'动工提醒', dataIndex:'ydkgsj', width:100, renderer:warnKG, sortable:false},
//                {text:'竣工提醒', dataIndex:'ydjgsj', width:100, renderer:warnJG,sortable:false},
                {text:'地块编号', dataIndex:'dkbh', width:100},
                {text:'项目名称', dataIndex:'xmmc', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {text:'用途', dataIndex:'yt', width:100},
                {
                    text: '分类代码',
                    dataIndex: 'fldm',
                    width: 100
                },
                {text:'约定开工时间', dataIndex:'ydkgsj', width:120, renderer:dateFormat},
                {text:'约定竣工时间', dataIndex:'ydjgsj', width:120, renderer:dateFormat},
                {
                    text: '实际开工时间',
                    dataIndex: 'sjkgsj',
                    width: 120,
                    renderer: dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d',
//                        minValue: '01/01/06',
//                        minText: 'Cannot have a start date before the company existed!',
                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }
                },
                {
                    text:'实际竣工时间',
                    dataIndex:'sjjgsj',
                    width:120,
                    renderer:dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d',
//                        minValue: '01/01/06',
//                        minText: 'Cannot have a start date before the company existed!',
                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }
                },
                {
                    text:'是否建成',
                    dataIndex:'sfjc',
                    width:120,
                    renderer:function (value){
                        if(value==1){
                            return "是";
                        }else{
                            return "否";
                        }
                    }
                },
                {text:'建设状态', dataIndex:'jszt', width:120}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:false,
                trackOver:false,
                id:'idleLandGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                                cellEditing.startEdit(0,11);
//                            }
//                        }
//                    },
                    {
                        text: '导出数据',
                        xtype:'button',
                        iconCls: 'export',
                        width: 75,
                        handler: function(){
                            debugger;
                            return window.location = '/emapserver/warn/warn!exportYj.action?type='+'${type!}';
                        }
                    },
                    {
                        text:'搜索',
                        xtype:'button',
                        handler:function(){
//                            alert("搜索");
                            debugger;
                            searchForm.show();
                        }
                    },
                    {
                        id:"clearBtn",
                        text:'清除',
                        xtype:'button',
                        hidden:true,
                        handler:function(){
//                            alert("搜索");
                            debugger;
                            store.proxy.extraParams= null;
                            store.load();
                            Ext.getCmp("clearBtn").hide();
                        }
                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }



                ]
            })
//            plugins: [rowEditing]
        });
//        Ext.create('Ext.tip.ToolTip', {
//            target:gridPanel.getView().el,
//            delegate: gridPanel.getView().itemSelector,
//            trackMouse: true,
//            html: '双击编辑'
//        });

    });


    /**
     *
     * 预警
     * */
    function warnRenderer(value, p, r){
        var record = r.data;
        var current_date = new Date();
        var ydkgsj = getDate(record.ydkgsj);
        var ydjgsj = getDate(record.ydjgsj);
        var kgsj = getDate(record.sjkgsj);
        var jgsj = getDate(record.sjjgsj);
        var sfjc = record.sfjc;
        var jszt = record.jszt;

        if ((!ydjgsj && !ydkgsj) || sfjc==1)
            return null;
        //约定开工时间差值，天数
        var diffKg = dateDiff(ydkgsj,current_date)/(24 * 60 * 60 * 1000);
        //约定竣工时间差值,天数
        var diffJg = dateDiff(ydjgsj,current_date)/(24 * 60 * 60 * 1000);
        if (0 <= diffKg && diffKg <= 30 && kgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-exclamation-sign' style='color: green' title='约定开工前一个月，开工时间未填写'></span></div>";
        else if (diffJg >= 0 && diffJg <= 30 && diffKg <= 0 && kgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-warning-sign' style='color: blue' title='约定开工时间到约定竣工前一个月时间段内，开工时间未填写'></span></div>";
        else if (diffKg >= 0 && diffJg <= 30 && jgsj == null && sfjc==0 && jszt=="建成面积不足1/3")
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-fire' style='color: #ffff00' title='约定竣工前一个月，竣工时间未填,是否建成字段为0，建设状态是“建成面积不足1/3'></span></div>";
        else if (diffJg < 0 && jgsj == null && sfjc==0 && jszt=="建成面积不足1/3")
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-flash' style='color: #ff0000' title='约定竣工后，竣工时间未填写，是否建成字段为0，建设状态是“建成面积不足1/3'></span></div>";
        else
            return null;
    }

    function getDate(val){
        if(!val)return null;
        if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
            return new Date(val)
        else
            return new Date(Date.parse(val.replace(/-/g, "/")));
    }

    /**
     *  开工预警
     * @param val
     */
    function warnKG(val) {
        if (val) {
            var date;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                if(current_date>date)
                return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>超期";
                else
                {
                    if(date.getMonth()==current_date.getMonth())
                    return "<span class=\"glyphicon glyphicon-info-sign orange\"></span>月内开工";
                }
            }
        }
        return "";
    }
    /**
     * 竣工预警
     * @param val
     */
    function warnJG(val,p,r) {
        if (val) {
            var date;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                if(current_date>date)
                    return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>超期";
                else
                {
                    if(date.getMonth()==current_date.getMonth())
                        return "<span class=\"glyphicon glyphicon-info-sign orange\"></span>月内竣工";
                }
            }
        }
        return "";
    }
    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }





</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>