<@com.html title="南通滨海园区土地动态监管系统" import="jquery,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {

        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
        }
        else return "";
    }

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'zdModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'地块名称',dataIndex:'dkmc',width:100},
                {text:'项目名称',dataIndex:'proname',width:100},
                {text:'项目类型',dataIndex:'app_type',width:100},
                {text:'申请单位名称',dataIndex:'unit_name',width:100},
                {text:'批准文号',dataIndex:'pzwh',width:100},
                {text:'批准日期',dataIndex:'pzrq',width:120,renderer:dateFormat()},
                {text:'批准机关',dataIndex:'pzjg',width:100},
                {text:'项目状态',dataIndex:'xmzt',width:100},
                {text:'报批批次',dataIndex:'bppc',width:100},
                {text:'集体土地面积',dataIndex:'jttd',width:100},
                {text:'农用地面积',dataIndex:'nyd',width:100},
                {text:'耕地面积',dataIndex:'gd',width:100},
                {text:'未利用地面积',dataIndex:'wlyd',width:100},
                {text:'新增建设用地面积',dataIndex:'xzjsyd',width:120}

            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'zddkGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: []
        });
    });

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%"/>
</div>
</@com.html>