<@com.html title="南通滨海园区土地动态监管系统" import="jquery,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    function getCondition(params){
        debugger;
        var arr = [];
        for(var prop in params){
            var map = {};
            if(prop=='sqsj1'){
                map.field='SQSJ';
                map.condition='>';
                map.value="to_date('"+params[prop]+"','yyyy-MM-dd')";
            }
            if(prop=='sqsj2'){
                map.field='SQSJ';
                map.condition='<';
                map.value="to_date('"+params[prop]+"','yyyy-MM-dd')";
            }
            arr.push(map);
        }
        return arr;
    }

    var searchForm = new Ext.window.Window({
        frame:true,
        title: '融资抵押到期预警检索',
        bodyStyle:'padding:5px 5px 0',
        width: 350,
        defaultType: 'textfield',
        defaults: {
            anchor: '100%'
        },

        items:[{
            region: 'center',
            xtype: 'form',
            frame: true,
            defaultType: 'textfield',
            defaults: {
                anchor: '100%',
                width: '100%',
                labelSeparator: '：'
            },
            itemCls:'winFont',

            items: [
                    {
                        id:'sqsj1',
                        xtype:'datefield',
                        format:'Y-m-d',
                        fieldLabel: '申请时间开始',
                        name: 'sqsj1'
                    },
                    {
                        id:'sqsj2',
                        xtype:'datefield',
                        format:'Y-m-d',
                        fieldLabel: '申请时间结束',
                        name: 'sqsj2'
                    }

            ]
        }],

        buttons: [{
            text: '搜索',
            handler:function(){
                debugger;
                var form = searchForm.items.items[0].getForm();
                var param = form.getValues();
                var maps = {};
//                var map1 = {};
//                var map2 = {};
//                Array arr = new Array();
//                map1.field='SQSJ';
//                map1.condition='>';
//                map1.value=param.sqsj1;

//                arr.add(map1);
                maps.condition = Ext.encode(getCondition(param));
                store.proxy.extraParams = maps;
                searchForm.hide();
                store.load();
                Ext.getCmp("clearBtn").show();
            }
        },{
            text: '取消',
            handler:function(){
                searchForm.hide();
            }
        }]
    });

    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {
        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
        }
        else return "";
    }

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'xxgkModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'projectId', width:100,hidden:true},
                {text:'申请人姓名',dataIndex:'mc1',width:100},
                {text:'申请人工作单位',dataIndex:'gzdw',width:120},
                {text:'申请人证件种类',dataIndex:'zjzl1',width:120},
                {text:'申请人证件编号',dataIndex:'zjbh1',width:120},
                {text:'申请人联系电话',dataIndex:'lxdh1',width:120},
                {text:'申请人邮政编码',dataIndex:'yzbm1',width:120},
                {text:'申请人联系地址',dataIndex:'lxdz1',width:120},
                {text:'申请人传真',dataIndex:'cz1',width:100},
                {text:'申请人电子邮件',dataIndex:'dzyj1',width:120},
                {text:'申请组织名称',dataIndex:'mc2',width:120},
                {text:'组织机构代码',dataIndex:'zjbh2',width:120},
                {text:'申请组织法人代表',dataIndex:'frdb',width:120},
                {text:'申请组织联系人名称',dataIndex:'lxrmc',width:120},
                {text:'申请组织联系电话',dataIndex:'lxdh2',width:120},
                {text:'申请组织传真',dataIndex:'cz2',width:120},
                {text:'申请组织联系地址',dataIndex:'lxdz2',width:120},
                {text:'申请组织电子邮件',dataIndex:'dzyj2',width:120},
                {text:'申请时间',dataIndex:'sqsj',width:100,renderer:dateFormat},
                {text:'信息描述',dataIndex:'nrms',width:100},
                {text:'信息用途',dataIndex:'yt',width:100},
                {text:'信息提供方式',dataIndex:'tgfs',width:100},
                {text:'获取信息方式',dataIndex:'hqxxfs',width:100},
                {text:'是否符合条例',dataIndex:'sffhtl',width:100},
                {text:'不符合原因',dataIndex:'bfhyy',width:100},
                {text:'备注',dataIndex:'bz',width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'xxgkGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                        {
                            text:'搜索',
                            xtype:'button',
                            handler:function(){
                                debugger;
                                searchForm.show();
                            }
                        },
                        {
                            id:"clearBtn",
                            text:'清除',
                            xtype:'button',
                            hidden:true,
                            handler:function(){
                                debugger;
                                store.proxy.extraParams= null;
                                store.load();
                                Ext.getCmp("clearBtn").hide();
                            }
                        },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: []

        });
    });

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%"/>
</div>
</@com.html>