<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });
    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            if (params.sfxc)
                params.sfxc = 1;
            else
                params.sfxc = 0;
            $.ajax({

                url: "/emapserver/ledger/ledger!update.action?type=${type!}",
                data: {
                    wfyd: JSON.stringify(params)
                },
                success: function (response,_s) {
                    var result = JSON.parse(response);
                    myMask.hide();
                    if(result.success)
                    {
                        alert(result.msg);
                    }else
                    {
                        alert(result.msg);
                    }
                    store.load();
                },
                failure: function (response, opts) {
                    myMask.hide();
                    alert(response);
                }
            });
        }
    });


    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'wfydModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
//            selModel:cbSelModel,
//            multiSelect:true,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'图形定位', width:50, renderer:mapRenderer,sortable:false},
                {text:'行政区代码', dataIndex:'regioncode', width:100},
                {text:'责任片警', dataIndex:'zrpj', width:100},
                {text:'占地时间', dataIndex:'zdsj', width:100,renderer:dateFormat},
                {text:'发现时间', dataIndex:'fxsj', width:100,renderer:dateFormat},
                {text:'违法行为人', dataIndex:'wfxwr', width:100},
                {text:'地点', dataIndex:'address', width:100},
                {text:'占用土地类型', dataIndex:'zytdlx', width:100},
                {text:'制止措施', dataIndex:'zzcs', width:100},
                {text:'拆除时间', dataIndex:'ccsj', width:100,renderer:dateFormat},
                {text:'拆除建筑面积', dataIndex:'ccjzmj', width:100},
                {text:'状态', dataIndex:'zt', width:100},
                {
//                    xtype: 'checkcolumn',
                    text: '是否消除',
                    dataIndex: 'sfxc',
                    width: 100,
                    renderer:boolRenderer,
                    editor: {
                        xtype: 'checkbox',
                        cls: 'x-grid-checkheader-editor'
                    }
                }
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'wfydGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        listeners:{
//                            click:function(){
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: [rowEditing]

        });

        Ext.create('Ext.tip.ToolTip', {
            target:gridPanel.getView().el,
            delegate: gridPanel.getView().itemSelector,
            trackMouse: true,
            html: '双击编辑'
        });

    });
    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {

        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
        }
        else return "";
    }

    /**
     *
     * */
    function boolRenderer(val){
        if (val) {
            return '已消除';
        } else
            return '未消除';
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>