<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });


    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){

        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'lbgdModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:true,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'图形定位', width:50, renderer:mapRenderer,sortable:false},
                {text:'地块名称', dataIndex:'dkmc', width:100},
                {text:'地块编号', dataIndex:'dkbh', width:100},
                {text:'地块位置', dataIndex:'zl', width:100},
                {text:'地块用途', dataIndex:'yt', width:100},
                {text:'挂牌价格', dataIndex:'gpjg', width:100},
                {text:'地块面积', dataIndex:'mj', width:100},
                {text:'流标原因', dataIndex:'lbyy', width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'lbgdGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                    {
                        xtype:'box',
                        width:20
                    },
                    {
                        text: '新增',
                        xtype: 'button',
                        iconCls: 'add',
                        listeners:{
                            click:function(){

                                var w_width = screen.availWidth - 10;
                                var w_height = screen.availHeight - 32;
                                window.open("/emapserver/map/map.action?openWidgets=PlotEdit&hideSysmenu=true&type=lbgd&editProperty=true", "_map", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");

                            }
                        }
                    },'-',
                    {
                        text: '删除',
                        xtype: 'button',
                        iconCls: 'del',
                        listeners:{
                            click:function(){

                                var rows = gridPanel.getSelectionModel().getSelection();
                                if(rows==null||rows.length==0){
                                    Ext.Msg.alert('提示', "请选择要操作的数据！");
                                    return;
                                }
                                var ids=new Array();
                                for (var i = 0; i < rows.length; i++) {
                                    ids.push(rows[i].get('objectId'));
                                }
                                alert(ids.join(","));

                                var myMask = new Ext.LoadMask(Ext.getBody(), {
                                    msg: '正在删除，请稍后...',
                                    removeMask: true
                                });
                                myMask.show();
                                $.ajax({
                                    url:'/emapserver/ledger/ledger!delete.action?type='+'${type!}',
                                    data:{
                                        ids:ids.join(",")
                                    },
                                    success: function (response,_s) {

                                        myMask.hide();
                                        store.load();
                                    },
                                    failure:function(response,s){
                                        myMask.hide();
                                    }
                                });
                            }
                        }
                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            })
//            plugins: [rowEditing]

        });

    });

    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {

        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
        }
        else return "";
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>