<@com.html title="南通滨海园区土地动态监管系统" import="jquery,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'kczyModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'编号',dataIndex:'bh',width:100},
                {text:'疏浚河道名称',dataIndex:'sjhdmc',width:100},
                {text:'疏浚河道地点',dataIndex:'sjhddd',width:100},
                {text:'平均深度（米）',dataIndex:'pjsd',width:100},
                {text:'采矿量（立方米）',dataIndex:'ckl',width:100},
                {text:'采矿权出让底价（元）',dataIndex:'ckqcrdj',width:140},
                {text:'保证金（元）',dataIndex:'bzj',width:100},
                {text:'备注',dataIndex:'bz',width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'xxgkGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: []

        });
    });

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%"/>
</div>
</@com.html>