<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
    <style type="text/css">

    </style>

    <script type="text/javascript">
        var store, gridPanel, editWindow;
        var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
        var minHeight = Ext.getBody().getViewSize().height-135;

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.toolbar.Paging',
            'Ext.ModelManager',
            'Ext.tip.QuickTipManager',
            'Ext.form.field.Checkbox'
        ]);

        /**
         *  格式化时间显示样式
         * @param val
         */
        function dateFormat(val) {

            if (val) {
                if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                    return Ext.util.Format.date(new Date(val), "Y年m月d日");
                else
                    return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
            }
            else return "";
        }

        /**
         * 判断显示是否分期
         * @param val
         * @returns {string}
         */
        function sffq(val){
            if(val==0){
                return "不分期";
            }else{
                return "已分期";
            }
        }

        /**
         * 判断显示是否建成
         * @param val
         * @returns {string}
         */
        function sfjc(val){
            if(val==0){
                return "未建成";
            }else{
                return "已建成";
            }
        }

        /**
         * 判断显示是否缴纳
         * @param val
         * @returns {string}
         */
        function sfjn(val){
            if(val==0){
                return "未缴纳";
            }else{
                return "已缴纳";
            }
        }

        var sfjcStore = Ext.create('Ext.data.Store',{
            fields: ['id','value'],
            data : [
                {id:"未建成",value:"0"},
                {id:"已建成",value:"1"}
            ]
        });

        var sffqStore = Ext.create('Ext.data.Store',{
            fields: ['id','value'],
            data : [
                {id:"未分期",value:"0"},
                {id:"分期",value:"1"}
            ]
        });

        var jsztStore = Ext.create('Ext.data.Store',{
            fields: ['id','value'],
            data : [
                {id:"建成面积不足1/3",value:"建成面积不足1/3"},
                {id:"建成面积超过1/3",value:"建成面积超过1/3"}
            ]
        });

        /**
         * 判断是否分期，选择不同的表单项
         * @param value
         */
        function checkSffq(value){
            if(value == 1){
                Ext.getCmp("yjId").disable(true);
                Ext.getCmp("yq1").enable(true);
                Ext.getCmp("yq2").enable(true);
                Ext.getCmp("yq3").enable(true);
                Ext.getCmp("eq1").enable(true);
                Ext.getCmp("eq2").enable(true);
                Ext.getCmp("eq3").enable(true);
                Ext.getCmp("sq1").enable(true);
                Ext.getCmp("sq2").enable(true);
                Ext.getCmp("sq3").enable(true);
            }else{
                Ext.getCmp("yjId").enable(true);
                Ext.getCmp("yq1").disable(true);
                Ext.getCmp("yq2").disable(true);
                Ext.getCmp("yq3").disable(true);
                Ext.getCmp("eq1").disable(true);
                Ext.getCmp("eq2").disable(true);
                Ext.getCmp("eq3").disable(true);
                Ext.getCmp("sq1").disable(true);
                Ext.getCmp("sq2").disable(true);
                Ext.getCmp("sq3").disable(true);
            }
        }

        /**
         * 已交出让金自动填写为一、二、三期实际缴纳出让金之和。
         */
        function getAllsjcrj(){
            debugger;
            var value = parseFloat(Ext.getCmp("yq3").value)+parseFloat(Ext.getCmp("eq3").value)+parseFloat(Ext.getCmp("sq3").value);
            var form = editWindow.items.items[0].getForm();
            form.setValues({
                'gddk.sjcrj':value
            });
        }

        var formPanel = Ext.create('Ext.form.Panel',{
            height : 280,
            width : 560,
//            frame : true,
            layout : 'form',
            buttonAlign:'center',
            autoScroll:true,

            items:[
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [
                    {
                        xtype:'hiddenfield',
                        name : 'gddk.objectId'
                    },
                    {
                        id : 'sjkgDate',
                        xtype : 'datefield',
                        fieldLabel : '实际动工时间',
                        name : 'gddk.sjkgsj',
                        format:'Y-m-d'
                    },
                    {
                        id : 'sjjgDate',
                        xtype : 'datefield',
                        fieldLabel : '实际竣工时间',
                        name : 'gddk.sjjgsj',
                        format:'Y-m-d'
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [
                                {
                                    xtype: 'combobox',
                                    fieldLabel: '是否建成',
                                    name: 'gddk.sfjc',
                                    valueField: 'value',
                                    displayField: 'id',
                                    store: sfjcStore,
                                },
                                {
                                    xtype: 'combobox',
                                    fieldLabel: '建设状态',
                                    name: 'gddk.jszt',
                                    valueField: 'value',
                                    displayField: 'id',
                                    store: jsztStore,
                                }
                            ]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        xtype : 'combobox',
                        fieldLabel : '是否分期',
                        name:'gddk.sffq',
                        valueField: 'value',
                        displayField: 'id',
                        store:sffqStore,
                        listeners: {
                            select: function(obj){
                                debugger;
                                checkSffq(obj.value);
                            }
                        }
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"yjId",
                        xtype : 'textfield',
                        fieldLabel : '已缴出让金',
                        name:'gddk.sjcrj'
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"yq1",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '一期应缴出让金',
                        name:'gddk.yjcrj1'

                    },
                    {
                        id:"yq2",
                        disabled:true,
                        xtype : 'datefield',
                        fieldLabel : '一期应缴时间',
                        name:'gddk.crjsj1',
                        format:'Y-m-d'
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"yq3",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '一期实缴出让金',
                        name:'gddk.sjcrj1',
                        listeners: {
                            'blur':function(){
//                                alert(1);
                                getAllsjcrj();
                            }
                        }
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"eq1",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '二期应缴出让金',
                        name:'gddk.yjcrj2'
                    },
                    {
                        id:"eq2",
                        disabled:true,
                        xtype : 'datefield',
                        fieldLabel : '二期应缴时间',
                        name:'gddk.crjsj2',
                        format:'Y-m-d'
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"eq3",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '二期实缴出让金',
                        name:'gddk.sjcrj2',
                        listeners: {
                            'blur':function(){
//                                alert(1);
                                getAllsjcrj();
                            }
                        }
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"sq1",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '三期应缴出让金',
                        name:'gddk.yjcrj3'
                    },
                    {
                        id:"sq2",
                        disabled:true,
                        xtype : 'datefield',
                        fieldLabel : '三期应缴时间',
                        name:'gddk.crjsj3',
                        format:'Y-m-d'
                    }]
                },
                {
                    xtype : 'form',
                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [{
                        id:"sq3",
                        disabled:true,
                        xtype : 'textfield',
                        fieldLabel : '三期实缴出让金',
                        name:'gddk.sjcrj3',
                        listeners: {
                            'blur':function(){
//                                alert(1);
                                getAllsjcrj();
                            }
                        }
                    }]
                }
            ],
            buttons:[
                {
                    text: '修改',
                    handler:function(){
                        var form = editWindow.items.items[0].getForm();
                        form.submit({
                            waitMsg:"正在向服务器提交数据中...",
                            url:'ledger!update.action?type='+'${type!}',
                            success: function (f, a) {
                                if(a.result.success==true){
                                    editWindow.hide();
                                    Ext.MessageBox.alert("提示", a.result.msg);
                                    store.load();
                                }else{
                                    Ext.MessageBox.alert("提示", a.result.msg);
                                }
                            },
                            failure: function (f,a) {
                                Ext.MessageBox.alert("提示", a.result.msg);
                            }
                        });
                    }
                },
                {
                    text: '取消',
                    handler:function(){
                        editWindow.hide();
                    }
                }
            ]
        });

        editWindow = new Ext.window.Window({
//            frame:true,
            closeAction: 'hide',
            title: '供地台帐信息编辑',
            width: 560,
            defaultType: 'textfield',
            defaults: {
                anchor: '100%'
            },

            items:[formPanel]
        });

        Ext.onReady(function(){
            Ext.tip.QuickTipManager.init();

            store = new Ext.data.Store({
                pageSize:pageSize,
                model:'gddkModel',
                proxy:{
                    type:'ajax',
                    url:'ledger!list.action?type='+'${type!}',
                    reader:{
                        type:'json',
                        root:'items',
                        totalProperty:'totalCount'
                    }
                },
                autoLoad:true
            });

            gridPanel = new Ext.grid.Panel({
                percentageWidths:100,
                percentageHeights:100,
                minHeight:minHeight,
                selModel:cbSelModel,
                multiSelect:false,
                store:store,
                stateful:true,
                columns:[
                    {text:'id', dataIndex:'objectId', width:100,hidden:true},
                    {text:'地块编号', dataIndex:'dkbh', width:100},
                    {text:'项目名称', dataIndex:'xmmc', width:100},
                    {text:'土地坐落', dataIndex:'tdzl', width:100},
                    {text:'用途', dataIndex:'yt', width:100},
                    {text:'供地方式', dataIndex:'gdfs', width:100},
                    {text:'土地使用者', dataIndex:'tdsyz', width:100},
                    {text:'文号', dataIndex:'wh', width:100},
                    {text:'签订日期', dataIndex:'qdrq', width:120, renderer:dateFormat},
                    {text:'来源', dataIndex:'ly', width:100},
                    {text:'年限', dataIndex:'nx', width:100},
                    {text:'备注', dataIndex:'bz', width:100},
                    {text:'年份', dataIndex:'nf', width:100},
                    {text:'面积', dataIndex:'mj', width:100},
                    {text:'投资额', dataIndex:'tze', width:100},
                    {text:'约定开工时间', dataIndex:'ydkgsj', width:120, renderer:dateFormat},
                    {text:'约定竣工时间', dataIndex:'ydjgsj', width:120, renderer:dateFormat},
                    {text:'实际开工时间', dataIndex:'sjkgsj', width:120, renderer:dateFormat},
                    {text:'实际竣工时间', dataIndex:'sjjgsj', width:120, renderer:dateFormat},
                    {text:'用地面积', dataIndex:'gdzmj', width:100},
                    {text:'新增面积', dataIndex:'xzmj', width:100},
                    {text:'存量面积', dataIndex:'clmj', width:100},
                    {text:'实缴出让金', dataIndex:'sjcrj', width:100},
                    {text:'应缴出让金', dataIndex:'yjcrj', width:100},
                    {text:'出让金到期时间', dataIndex:'crjsj', width:120, renderer:dateFormat},
                    {text:'实际缴纳出让金时间', dataIndex:'sjcrjsj', width:120, renderer:dateFormat},
                    {text:'是否分期缴纳出让金', dataIndex:'sffq', width:100, renderer:sffq},
                    {text:'一期应缴出让金', dataIndex:'yjcrj1', width:100},
                    {text:'一期实际缴纳出让金', dataIndex:'sjcrj1', width:100},
                    {text:'一期应缴时间', dataIndex:'crjsj1', width:120, renderer:dateFormat},
                    {text:'一期实际缴纳时间', dataIndex:'sjcrjsj1', width:120, renderer:dateFormat},
                    {text:'二期应缴出让金', dataIndex:'yjcrj2', width:100},
                    {text:'二期实际缴纳出让金', dataIndex:'sjcrj2', width:100},
                    {text:'二期应缴时间', dataIndex:'crjsj2', width:120, renderer:dateFormat},
                    {text:'二期实际缴纳时间', dataIndex:'sjcrjsj2', width:120, renderer:dateFormat},
                    {text:'三期应缴出让金', dataIndex:'yjcrj3', width:100},
                    {text:'三期实际缴纳出让金', dataIndex:'sjcrj3', width:100},
                    {text:'三期应缴时间', dataIndex:'crjsj3', width:120, renderer:dateFormat},
                    {text:'三期实际缴纳时间', dataIndex:'sjcrjsj3', width:120, renderer:dateFormat},
                    {text:'三期实际缴纳时间', dataIndex:'sjcrjsj3', width:120, renderer:dateFormat},
                    {text:'是否建成', dataIndex:'sfjc', width:100, renderer:sfjc},
                    {text:'是否缴纳', dataIndex:'sfjn', width:100, renderer:sfjn},
                    {text:'建设状态', dataIndex:'jszt', width:100}
                ],
                renderTo:'grid',
                viewConfig:{
                    stripeRows:true,
                    trackOver:false,
                    id:'gddkGrid'
                },
                bbar: Ext.create('Ext.PagingToolbar', {
                    store: store,
                    displayInfo: true,
                    displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                    emptyMsg: "尚未检测到数据"
                }),
                tbar: Ext.create('Ext.toolbar.Toolbar', {
                    items:[
                      {
                           text: '编辑',
                           xtype: 'button',
//                           iconCls: 'export',
                           width: 75,
                           listeners:{
                               click:function(){
                                   debugger;
                                   var selRow = gridPanel.getSelectionModel().getSelection();
                                   if(selRow.length==1){
                                       var form = editWindow.items.items[0].getForm();
                                       form.reset();
                                       form.setValues({
                                           'gddk.objectId': selRow[0].data.objectId,
                                           'gddk.sjkgsj': selRow[0].data.sjkgsj,
                                           'gddk.sjjgsj': selRow[0].data.sjjgsj,
                                           'gddk.sfjc': sfjcStore.getAt(selRow[0].data.sfjc).internalId,
                                           'gddk.jszt': selRow[0].data.jszt,
                                           'gddk.sffq': sffqStore.getAt(selRow[0].data.sffq).internalId,
                                           'gddk.sjcrj': selRow[0].data.sjcrj,
                                           'gddk.yjcrj1': selRow[0].data.yjcrj1,
                                           'gddk.crjsj1': selRow[0].data.crjsj1,
                                           'gddk.sjcrj1': selRow[0].data.sjcrj1,
                                           'gddk.yjcrj2': selRow[0].data.yjcrj2,
                                           'gddk.crjsj2': selRow[0].data.crjsj2,
                                           'gddk.sjcrj2': selRow[0].data.yjcrj2,
                                           'gddk.yjcrj3': selRow[0].data.yjcrj3,
                                           'gddk.crjsj3': selRow[0].data.crjsj3,
                                           'gddk.sjcrj3': selRow[0].data.sjcrj3
                                       });

                                       var sjkgDate = Ext.getCmp("sjkgDate");
                                       var sjjgDate = Ext.getCmp("sjjgDate");
                                       var dateyq2 = Ext.getCmp("yq2");
                                       var dateeq2 = Ext.getCmp("eq2");
                                       var datesq2 = Ext.getCmp("sq2");

                                       debugger;
                                       if(selRow[0].data.sjkgsj!=null &&　selRow[0].data.sjkgsj!=''){
                                           sjkgDate.setValue(new Date(selRow[0].data.sjkgsj));
                                       }
                                       if(selRow[0].data.sjjgsj!=null &&　selRow[0].data.sjjgsj!=''){
                                           sjjgDate.setValue(new Date(selRow[0].data.sjjgsj));
                                       }
                                       if(selRow[0].data.crjsj1!=null &&　selRow[0].data.crjsj1!=''){
                                           dateyq2.setValue(new Date(selRow[0].data.crjsj1));
                                       }
                                       if(selRow[0].data.crjsj2!=null &&　selRow[0].data.crjsj2!=''){
                                           dateeq2.setValue(new Date(selRow[0].data.crjsj2));
                                       }
                                       if(selRow[0].data.crjsj3!=null &&　selRow[0].data.crjsj3!=''){
                                           datesq2.setValue(new Date(selRow[0].data.crjsj3));
                                       }

                                       checkSffq(selRow[0].data.sffq);

                                       editWindow.show();
                                   }else if(selRow.length==0){
                                       Ext.MessageBox.show({
                                           title:'提示',
                                           msg:'请您选择一行台帐信息后再编辑',
                                           icon:Ext.Msg.INFO
                                       });
                                   }else if(selRow.length>1){
                                       Ext.MessageBox.show({
                                           title:'提示',
                                           msg:'您只能选择一行台帐信息后再编辑',
                                           icon:Ext.Msg.INFO
                                       });
                                   }

                               }
                           }
                        },
                        '->',
                        {
                            xtype:'textfield',
                            name:'searchField',
                            hideLabel:true,
                            emptyText:'快速检索',
                            listeners:{
                                change:function () {
                                    onSearch(gridPanel);
                                }
                            }
                        }

                    ]
                }),
                plugins: [],
                listeners:{
                    //双击打开编辑表单编辑信息
//                    "itemdblclick": function onRowDoubleClick(){
//                        editWindow.show();
//                        alert(1);
//                    }
                }

            });
        });

    </script>
    <div id="warp">
        <div id="grid" style="height:100%;width:100%">

        </div>
    </div>
</@com.html>