<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
    <style type="text/css">

    </style>

    <script type="text/javascript">
        var store, gridPanel, editWindow;
        var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
        var minHeight = Ext.getBody().getViewSize().height-135;

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.toolbar.Paging',
            'Ext.ModelManager',
            'Ext.tip.QuickTipManager',
            'Ext.form.field.Checkbox'
        ]);

        /**
         * 是否注销
         * @param val
         * @returns {string}
         */
        function zxRenderer(val) {
            if (val == 1)
                return '是';
            else
                return '否';
        }

        /**
         *  格式化时间显示样式
         * @param val
         */
        function dateFormat(val) {
            if (val) {
                if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                    return Ext.util.Format.date(new Date(val), "Y年m月d日");
                else
                    return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
            }
            else return "";
        }

        var formpanel = new Ext.form.Panel({
            width : 300,
            layout : 'form',
            buttonAlign:'center',
            items:[
                {
                    xtype : 'form',
//                    layout : 'column',
                    frame : true,
                    baseCls : 'my-panel-no-border',  //去掉边框
                    items : [
                        {
                            xtype:'hiddenfield',
                            name : 'djdk.objectId'
                        },
                        {
                            id : 'dylx',
                            xtype : 'textfield',
                            fieldLabel : '抵押类型',
                            name : 'djdk.dylx'
                        },
                        {
                            id : 'dydqDate',
                            xtype : 'datefield',
                            fieldLabel : '抵押到期时间',
                            name : 'djdk.dydqsj',
                            format:'Y-m-d'
                        }]
                }
            ]
        });

        editWindow = new Ext.window.Window({
            title: '登记台帐信息编辑',
            width: 300,
            buttonAlign:'center',
            closeAction: 'hide',
            defaultType: 'textfield',
            defaults: {
                anchor: '100%'
            },
            items:[formpanel],
            buttons:[
                {
                    text:'修改',
                    xtype: 'button',
                    listeners:{
                        'click':function(){
                            var form = editWindow.items.items[0].getForm();
                            form.submit({
                                waitMsg:"正在向服务器提交数据中...",
                                url:'ledger!update.action?type='+'${type!}',
                                success: function (f, a) {
                                    debugger;
                                    if(a.result.success==true){
                                        editWindow.hide();
                                        Ext.MessageBox.alert("提示", a.result.msg);
                                        store.load();
                                    }else{
                                        Ext.MessageBox.alert("提示", a.result.msg);
                                    }
                                },
                                failure: function (f,a) {
                                    Ext.MessageBox.alert("提示", a.result.msg);
                                }
                            });
                        }
                    }
                },
                {
                    text:'取消',
                    xtype: 'button',
                    listeners:{
                        'click':function(){
                            editWindow.hide();
                        }
                    }
                }
            ]
        });

        Ext.onReady(function(){
            Ext.tip.QuickTipManager.init();

            store = new Ext.data.Store({
                pageSize:pageSize,
                model:'djdkModel',
                proxy:{
                    type:'ajax',
                    url:'ledger!list.action?type='+'${type!}',
                    reader:{
                        type:'json',
                        root:'items',
                        totalProperty:'totalCount'
                    }
                },
                autoLoad:true
            });

            gridPanel = new Ext.grid.Panel({
                percentageWidths:100,
                percentageHeights:100,
                minHeight:minHeight,
                selModel:cbSelModel,
                multiSelect:false,
                store:store,
                stateful:true,
                columns:[
                    {text:'id', dataIndex:'objectId', width:100,hidden:true},
                    {text:'土地证号',dataIndex:'tdzh',width:200},
                    {text:'单位名称', dataIndex:'dwmc1', width:100},
                    {text:'土地坐落', dataIndex:'tdzl', width:100},
                    {text:'是否注销', dataIndex:'sfzx', width:100,renderer:zxRenderer},
                    {id:'tip1',text:'抵押类型', dataIndex:'dylx', width:100},
                    {text:'抵押到期时间', dataIndex:'dydqsj', width:120,renderer:dateFormat}
                ],
                renderTo:'grid',
                viewConfig:{
                    stripeRows:true,
                    trackOver:false,
                    id:'djdkGrid'
                },
                bbar: Ext.create('Ext.PagingToolbar', {
                    store: store,
                    displayInfo: true,
                    displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                    emptyMsg: "尚未检测到数据"
                }),
                tbar: Ext.create('Ext.toolbar.Toolbar', {
                    items:[
                        {
                            text: '编辑',
                            xtype: 'button',
                            width: 75,
                            listeners: {
                                'click':function(){
                                    var selRow = gridPanel.getSelectionModel().getSelection();
                                    if(selRow.length==1) {
                                        var form = editWindow.items.items[0].getForm();
                                        form.reset();
                                        form.setValues({
                                            'djdk.objectId':selRow[0].data.objectId,
                                            'djdk.dylx':selRow[0].data.dylx
                                        });

                                        var dydqDate = Ext.getCmp("dydqDate");

                                        if(selRow[0].data.dydqsj!=null && selRow[0].data.dydqsj!=''){
                                            dydqDate.setValue(new Date(selRow[0].data.dydqsj));
                                        }

                                        editWindow.show();
                                    }else if(selRow.length==0){
                                        Ext.MessageBox.show({
                                            title:'提示',
                                            msg:'请您选择一行台帐信息后再编辑',
                                            icon:Ext.Msg.INFO
                                        });
                                    }else if(selRow.length>1){
                                        Ext.MessageBox.show({
                                            title:'提示',
                                            msg:'您只能选择一行台帐信息后再编辑',
                                            icon:Ext.Msg.INFO
                                        });
                                    }
                                }
                            }
                        },
                        '->',
                        {
                            xtype:'textfield',
                            name:'searchField',
                            hideLabel:true,
                            emptyText:'快速检索',
                            listeners:{
                                change:function () {
                                    onSearch(gridPanel);
                                }
                            }
                        }

                    ]
                }),
                plugins: []
            });
        });

    </script>

    <div id="warp">
        <div id="grid" style="height:100%;width:100%">

        </div>
    </div>
</@com.html>