<@com.html title="南通滨海园区土地动态监管系统" import="jquery,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;


    var formpanel = new Ext.form.Panel({
        width : 300,
        layout : 'form',
        buttonAlign:'center',
        items:[
            {
                xtype : 'form',
//                    layout : 'column',
                frame : true,
                baseCls : 'my-panel-no-border',  //去掉边框
                items : [
                    {
                        xtype:'hiddenfield',
                        name : 'clkzd.objectId'
                    },
                    {
                        xtype : 'textfield',
                        fieldLabel : '巡查记录',
                        name : 'clkzd.xcjl'
                    },
                    {
                        xtype : 'textfield',
                        fieldLabel : '测量标志情况',
                        name : 'clkzd.clbzqk'
                    }]
            }
        ]
    });

    editWindow = new Ext.window.Window({
        title: '登记台帐信息编辑',
        width: 300,
        buttonAlign:'center',
        closeAction: 'hide',
        defaultType: 'textfield',
        defaults: {
            anchor: '100%'
        },
        items:[formpanel],
        buttons:[
            {
                text:'修改',
                xtype: 'button',
                listeners:{
                    'click':function(){
                        var form = editWindow.items.items[0].getForm();
                        form.submit({
                            waitMsg:"正在向服务器提交数据中...",
                            url:'ledger!update.action?type='+'${type!}',
                            success: function (f, a) {
                                debugger;
                                if(a.result.success==true){
                                    editWindow.hide();
                                    Ext.MessageBox.alert("提示", a.result.msg);
                                    store.load();
                                }else{
                                    Ext.MessageBox.alert("提示", a.result.msg);
                                }
                            },
                            failure: function (f,a) {
                                Ext.MessageBox.alert("提示", a.result.msg);
                            }
                        });
                    }
                }
            },
            {
                text:'取消',
                xtype: 'button',
                listeners:{
                    'click':function(){
                        editWindow.hide();
                    }
                }
            }
        ]
    });

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'clkzdModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'entity',dataIndex:'entity',width:100},
                {text:'handler',dataIndex:'handler',width:100},
                {text:'layer',dataIndex:'layer',width:100},
                {text:'ghyname',dataIndex:'ghyname',width:100},
                {text:'xb',dataIndex:'xb',width:100},
                {text:'sfzhm',dataIndex:'sfzhm',width:100},
                {text:'lxdh',dataIndex:'lxdh',width:100},
                {text:'bzdw',dataIndex:'bzdw',width:100},
                {text:'fldm',dataIndex:'fldm',width:100},
                {text:'巡查记录',dataIndex:'xcjl',width:100},
                {text:'测量标注情况',dataIndex:'clbzqk',width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'xxgkGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                    {
                        text: '编辑',
                        xtype: 'button',
                        width: 75,
                        listeners: {
                            'click':function(){
                                var selRow = gridPanel.getSelectionModel().getSelection();
                                if(selRow.length==1) {
                                    var form = editWindow.items.items[0].getForm();
                                    form.reset();
                                    form.setValues({
                                        'clkzd.objectId':selRow[0].data.objectId,
                                        'clkzd.clbzqk':selRow[0].data.clbzqk,
                                        'clkzd.xcjl':selRow[0].data.xcjl
                                    });

                                    editWindow.show();
                                }else if(selRow.length==0){
                                    Ext.MessageBox.show({
                                        title:'提示',
                                        msg:'请您选择一行台帐信息后再编辑',
                                        icon:Ext.Msg.INFO
                                    });
                                }else if(selRow.length>1){
                                    Ext.MessageBox.show({
                                        title:'提示',
                                        msg:'您只能选择一行台帐信息后再编辑',
                                        icon:Ext.Msg.INFO
                                    });
                                }
                            }
                        }
                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: []

        });
    });

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%"/>
</div>
</@com.html>