/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.utils.JxlCellUtils;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import jxl.CellType;
import jxl.NumberCell;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAction
extends BaseAction
implements ServletRequestAware {
    private Map<String, Object> data;
    private HttpServletRequest request;

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = this.data.get("alias") + "\u5206\u6790\u62a5\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("sheet1", 0);
            ws.setColumnView(0, 10);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 15);
            WritableFont titleFont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 11, WritableFont.NO_BOLD);
            WritableCellFormat cellFormat = new WritableCellFormat(titleFont);
            cellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
            cellFormat.setAlignment(Alignment.CENTRE);
            cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.BLACK);
            int startRow = 1;
            JSONArray value = (JSONArray)this.data.get("dict");
            for (int i = 0; i < value.size(); ++i) {
                JSONObject groupObj = (JSONObject)value.get(i);
                String groupTitle = (String)groupObj.get((Object)"title");
                JSONArray groupValue = (JSONArray)groupObj.get((Object)"value");
                ws.addCell((WritableCell)new Label(0, startRow, groupTitle, (CellFormat)cellFormat));
                ws.mergeCells(0, startRow, 0, groupValue.size() + startRow - 1);
                for (int j = 0; j < groupValue.size(); ++j) {
                    JSONObject singleObj = (JSONObject)groupValue.get(j);
                    String singleTitle = (String)singleObj.get((Object)"title");
                    BigDecimal areaValue = (BigDecimal)singleObj.get((Object)"value");
                    ws.addCell((WritableCell)new Label(1, startRow + j, singleTitle, (CellFormat)cellFormat));
                    if (areaValue == null) {
                        ws.addCell((WritableCell)new Number(2, startRow + j, 0.0, (CellFormat)cellFormat));
                        continue;
                    }
                    ws.addCell((WritableCell)new Number(2, startRow + j, areaValue.doubleValue(), (CellFormat)cellFormat));
                }
                startRow += groupValue.size();
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
        return null;
    }

    public void exportExcel() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String type = this.data.get("type").toString();
        String unit = this.data.get("unit").toString();
        String fileName = type.equals("1") ? "\u5206\u7c7b\u9762\u79ef\u8868(\u7b80\u8868)" : "\u5206\u7c7b\u9762\u79ef\u8868(\u8be6\u8868)";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xls", "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet(fileName, 0);
            WritableCellFormat cellFormat = JxlCellUtils.getNormolCell();
            if (type.equals("1")) {
                ws.setColumnView(0, 25);
                ws.setColumnView(1, 25);
                ws.setColumnView(2, 20);
                ws.setColumnView(3, 15);
                ws.setColumnView(4, 15);
                ws.setColumnView(5, 15);
                ws.setColumnView(6, 15);
                ws.setColumnView(7, 15);
                ws.setRowView(0, 1000);
                ws.setRowView(1, 400);
                ws.setRowView(2, 400);
                ws.setRowView(3, 400);
                ws.setRowView(4, 400);
                ws.addCell((WritableCell)new Label(0, 0, fileName, (CellFormat)JxlCellUtils.getHeader()));
                ws.addCell((WritableCell)new Label(7, 1, "\u5355\u4f4d:" + unit, (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.addCell((WritableCell)new Label(0, 2, "\u9879\u76ee", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(1, 2, "\u6743\u5c5e", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(2, 2, "\u603b\u9762\u79ef", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(3, 2, "\u65b0\u589e\u5efa\u8bbe\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(4, 3, "\u519c\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(6, 3, "\u672a\u5229\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(5, 4, "\u5176\u4e2d\u8015\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(7, 2, "\u5efa\u8bbe\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(4, 4, "", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(3, 3, "", (CellFormat)cellFormat));
                ws.mergeCells(0, 0, 7, 0);
                ws.mergeCells(0, 2, 0, 4);
                ws.mergeCells(1, 2, 1, 4);
                ws.mergeCells(2, 2, 2, 4);
                ws.mergeCells(3, 2, 6, 2);
                ws.mergeCells(4, 3, 5, 3);
                ws.mergeCells(6, 3, 6, 4);
                ws.mergeCells(7, 2, 7, 4);
                ws.mergeCells(3, 3, 3, 4);
                JSONArray array = (JSONArray)this.data.get("data");
                String proName = (String)this.data.get("proName");
                ws.addCell((WritableCell)new Label(0, 5, proName, (CellFormat)cellFormat));
                ws.mergeCells(0, 5, 0, 5 + array.size());
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject obj = (JSONObject)array.get(i);
                    String qsxz = obj.get((Object)"qsxz").toString();
                    double area = Double.valueOf(obj.get((Object)"area").toString());
                    double xzjsydArea = 0.0;
                    double nydArea = 0.0;
                    double gdArea = 0.0;
                    double wlydArea = 0.0;
                    double jsydArea = 0.0;
                    JSONArray arr = (JSONArray)obj.get((Object)"value");
                    for (int j = 0; j < arr.size(); ++j) {
                        JSONObject object = (JSONObject)arr.get(j);
                        JSONArray tbArr = (JSONArray)object.get((Object)"DLTB");
                        block24: for (int m = 0; m < tbArr.size(); ++m) {
                            JSONObject tbObj = (JSONObject)tbArr.get(m);
                            int preCode = Integer.valueOf(tbObj.get((Object)"dlbm").toString().substring(0, 2));
                            int lastCode = Integer.valueOf(tbObj.get((Object)"dlbm").toString().substring(2, 3));
                            double dltbArea = Double.valueOf(tbObj.get((Object)"area").toString());
                            switch (preCode) {
                                case 1: {
                                    nydArea += dltbArea;
                                    gdArea += dltbArea;
                                    continue block24;
                                }
                                case 2: {
                                    nydArea += dltbArea;
                                    continue block24;
                                }
                                case 3: {
                                    nydArea += dltbArea;
                                    continue block24;
                                }
                                case 4: {
                                    if (lastCode == 3) {
                                        wlydArea += dltbArea;
                                    }
                                    nydArea += dltbArea;
                                    continue block24;
                                }
                                case 10: {
                                    if (lastCode == 10) {
                                        nydArea += dltbArea;
                                        continue block24;
                                    }
                                    jsydArea += dltbArea;
                                    continue block24;
                                }
                                case 11: {
                                    if (lastCode == 4 || lastCode == 7) {
                                        nydArea += dltbArea;
                                        continue block24;
                                    }
                                    if (lastCode == 3 || lastCode == 8) {
                                        jsydArea += dltbArea;
                                        continue block24;
                                    }
                                    wlydArea += dltbArea;
                                    continue block24;
                                }
                                case 12: {
                                    if (lastCode == 2 || lastCode == 3) {
                                        nydArea += dltbArea;
                                        continue block24;
                                    }
                                    wlydArea += dltbArea;
                                    continue block24;
                                }
                                case 20: {
                                    jsydArea += dltbArea;
                                }
                            }
                        }
                    }
                    xzjsydArea = nydArea + wlydArea;
                    System.out.println("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef:" + xzjsydArea);
                    System.out.println("\u5efa\u8bbe\u7528\u5730\u9762\u79ef:" + jsydArea);
                    System.out.println("\u672a\u5229\u7528\u5730\u9762\u79ef:" + wlydArea);
                    System.out.println("\u519c\u7528\u5730\u9762\u79ef:" + nydArea);
                    System.out.println("\u8015\u5730\u9762\u79ef:" + gdArea);
                    ws.addCell((WritableCell)new Label(1, 5 + i, qsxz, (CellFormat)cellFormat));
                    ws.addCell((WritableCell)new Number(2, 5 + i, area, (CellFormat)JxlCellUtils.getNumberCell()));
                    ws.addCell((WritableCell)new Number(3, 5 + i, xzjsydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    ws.addCell((WritableCell)new Number(4, 5 + i, nydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    ws.addCell((WritableCell)new Number(5, 5 + i, gdArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    ws.addCell((WritableCell)new Number(6, 5 + i, wlydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    ws.addCell((WritableCell)new Number(7, 5 + i, jsydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    if (i + 1 != array.size()) continue;
                    ws.addCell((WritableCell)new Label(1, 6 + i, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                    for (int k = 2; k < 8; ++k) {
                        WritableCell nCell1 = ws.getWritableCell(k, 4 + i);
                        WritableCell nCell2 = ws.getWritableCell(k, 5 + i);
                        double value1 = nCell1 instanceof Number ? ((NumberCell)nCell1).getValue() : 0.0;
                        double value2 = nCell2 instanceof Number ? ((NumberCell)nCell2).getValue() : 0.0;
                        ws.addCell((WritableCell)new Number(k, 6 + i, value1 + value2, (CellFormat)JxlCellUtils.getNumberCell()));
                    }
                }
                ws.insertColumn(0);
            } else if (type.equals("2")) {
                ws.setColumnView(0, 20);
                ws.setColumnView(1, 20);
                ws.setColumnView(2, 35);
                for (int i = 3; i < 55; ++i) {
                    ws.setColumnView(i, 20);
                }
                ws.setRowView(0, 1000);
                ws.setRowView(1, 500);
                ws.addCell((WritableCell)new Label(0, 0, fileName, (CellFormat)JxlCellUtils.getHeader()));
                ws.mergeCells(0, 0, 54, 0);
                ws.addCell((WritableCell)new Label(54, 1, "\u5355\u4f4d:" + unit, (CellFormat)JxlCellUtils.getCustomizeCell((int)12, (Border)Border.NONE)));
                ws.addCell((WritableCell)new Label(0, 2, "\u6743\u5c5e", (CellFormat)cellFormat));
                ws.mergeCells(0, 2, 2, 4);
                ws.addCell((WritableCell)new Label(3, 2, "\u5408\u8ba1", (CellFormat)cellFormat));
                ws.mergeCells(3, 2, 3, 4);
                ws.addCell((WritableCell)new Label(4, 2, "\u65b0\u589e\u5efa\u8bbe\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(4, 2, 4, 4);
                ws.addCell((WritableCell)new Label(5, 2, "\u519c\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(5, 2, 25, 2);
                ws.addCell((WritableCell)new Label(26, 2, "\u5efa\u8bbe\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(26, 2, 41, 2);
                ws.addCell((WritableCell)new Label(42, 2, "\u672a\u5229\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(42, 2, 54, 2);
                ws.addCell((WritableCell)new Label(5, 3, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.mergeCells(5, 3, 5, 4);
                ws.addCell((WritableCell)new Label(6, 3, "\u8015\u5730", (CellFormat)cellFormat));
                ws.mergeCells(6, 3, 9, 3);
                ws.addCell((WritableCell)new Label(10, 3, "\u56ed\u5730", (CellFormat)cellFormat));
                ws.mergeCells(10, 3, 13, 3);
                ws.addCell((WritableCell)new Label(14, 3, "\u6797\u5730", (CellFormat)cellFormat));
                ws.mergeCells(14, 3, 17, 3);
                ws.addCell((WritableCell)new Label(18, 3, "\u5176\u4ed6\u519c\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(18, 3, 25, 3);
                ws.addCell((WritableCell)new Label(26, 3, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.mergeCells(26, 3, 26, 4);
                ws.addCell((WritableCell)new Label(27, 3, "\u57ce\u9547\u6751\u53ca\u5de5\u77ff\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(27, 3, 32, 3);
                ws.addCell((WritableCell)new Label(33, 3, "\u4ea4\u901a\u8fd0\u8f93\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(33, 3, 38, 3);
                ws.addCell((WritableCell)new Label(39, 3, "\u6c34\u5229\u8bbe\u65bd\u7528\u5730", (CellFormat)cellFormat));
                ws.mergeCells(39, 3, 41, 3);
                ws.addCell((WritableCell)new Label(42, 3, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.mergeCells(42, 3, 42, 4);
                ws.addCell((WritableCell)new Label(43, 3, "\u6c34\u57df", (CellFormat)cellFormat));
                ws.mergeCells(43, 3, 48, 3);
                ws.addCell((WritableCell)new Label(49, 3, "\u5176\u4ed6", (CellFormat)cellFormat));
                ws.mergeCells(49, 3, 54, 3);
                ws.addCell((WritableCell)new Label(6, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(7, 4, "\u6c34\u7530", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(8, 4, "\u6c34\u6d47\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(9, 4, "\u65f1\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(10, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(11, 4, "\u679c\u56ed", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(12, 4, "\u8336\u56ed", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(13, 4, "\u5176\u5b83\u56ed\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(14, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(15, 4, "\u6709\u6797\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(16, 4, "\u704c\u6728\u6797\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(17, 4, "\u5176\u4ed6\u6797\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(18, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(19, 4, "\u5929\u7136\u7267\u8349\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(20, 4, "\u4eba\u5de5\u7267\u8349\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(21, 4, "\u519c\u6751\u9053\u8def", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(22, 4, "\u5751\u5858\u6c34\u9762", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(23, 4, "\u6c9f\u6e20", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(24, 4, "\u8bbe\u65bd\u519c\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(25, 4, "\u7530\u574e", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(27, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(28, 4, "\u57ce\u5e02", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(29, 4, "\u5efa\u5236\u9547", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(30, 4, "\u6751\u5e84", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(31, 4, "\u91c7\u77ff\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(32, 4, "\u98ce\u666f\u540d\u80dc\u53ca\u7279\u6b8a\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(33, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(34, 4, "\u94c1\u8def\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(35, 4, "\u516c\u8def\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(36, 4, "\u673a\u573a\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(37, 4, "\u6e2f\u53e3\u7801\u5934\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(38, 4, "\u7ba1\u9053\u8fd0\u8f93\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(39, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(40, 4, "\u6c34\u5e93\u6c34\u9762", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(41, 4, "\u6c34\u5de5\u5efa\u7b51\u7528\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(43, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(44, 4, "\u6cb3\u6d41\u6c34\u9762", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(45, 4, "\u6e56\u6cca\u6c34\u9762", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(46, 4, "\u6cbf\u6d77\u6ee9\u6d82", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(47, 4, "\u5185\u9646\u6ee9\u6d82", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(48, 4, "\u51b0\u5ddd\u53ca\u6c38\u4e45\u79ef\u96ea", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(49, 4, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(50, 4, "\u5176\u4ed6\u8349\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(51, 4, "\u76d0\u78b1\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(52, 4, "\u6cbc\u6cfd\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(53, 4, "\u6c99\u5730", (CellFormat)cellFormat));
                ws.addCell((WritableCell)new Label(54, 4, "\u88f8\u5730", (CellFormat)cellFormat));
                JSONArray array = (JSONArray)this.data.get("data");
                String proName = (String)this.data.get("proName");
                int startRow = 5;
                double allArea = 0.0;
                ws.addCell((WritableCell)new Label(0, startRow, proName, (CellFormat)cellFormat));
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject obj = (JSONObject)array.get(i);
                    String qsxz = obj.get((Object)"qsxz").toString();
                    double area = Double.valueOf(obj.get((Object)"area").toString());
                    allArea += area;
                    JSONArray arr = (JSONArray)obj.get((Object)"value");
                    for (int j = 0; j < arr.size(); ++j) {
                        double xzjsydArea = 0.0;
                        double nydArea = 0.0;
                        double wlydArea = 0.0;
                        double jsydArea = 0.0;
                        double gdArea = 0.0;
                        double ydArea = 0.0;
                        double ldArea = 0.0;
                        double czgkydArea = 0.0;
                        double jtysydArea = 0.0;
                        double slssydArea = 0.0;
                        double syArea = 0.0;
                        double qtArea = 0.0;
                        JSONObject object = (JSONObject)arr.get(j);
                        String qsdwmc = object.get((Object)"QSDWMC").toString();
                        double qsdwarea = Double.valueOf(object.get((Object)"AREA").toString());
                        JSONArray tbArr = (JSONArray)object.get((Object)"DLTB");
                        block29: for (int m = 0; m < tbArr.size(); ++m) {
                            JSONObject tbObj = (JSONObject)tbArr.get(m);
                            int preCode = Integer.valueOf(tbObj.get((Object)"dlbm").toString().substring(0, 2));
                            int lastCode = Integer.valueOf(tbObj.get((Object)"dlbm").toString().substring(2, 3));
                            double dltbArea = Double.valueOf(tbObj.get((Object)"area").toString());
                            switch (preCode) {
                                case 1: {
                                    nydArea += dltbArea;
                                    gdArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(6 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 2: {
                                    nydArea += dltbArea;
                                    ydArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(10 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 3: {
                                    nydArea += dltbArea;
                                    ldArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(14 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 4: {
                                    if (lastCode == 3) {
                                        wlydArea += dltbArea;
                                        qtArea += dltbArea;
                                        ws.addCell((WritableCell)new Number(50, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    nydArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(18 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 10: {
                                    if (lastCode == 4) {
                                        nydArea += dltbArea;
                                        ws.addCell((WritableCell)new Number(21, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    jsydArea += dltbArea;
                                    jtysydArea += dltbArea;
                                    if (lastCode >= 5) {
                                        ws.addCell((WritableCell)new Number(31 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    ws.addCell((WritableCell)new Number(33 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 11: {
                                    if (lastCode == 4 || lastCode == 7) {
                                        nydArea += dltbArea;
                                        if (lastCode == 4) {
                                            ws.addCell((WritableCell)new Number(22, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                            continue block29;
                                        }
                                        ws.addCell((WritableCell)new Number(23, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    if (lastCode == 3 || lastCode == 8) {
                                        jsydArea += dltbArea;
                                        slssydArea += dltbArea;
                                        if (lastCode == 3) {
                                            ws.addCell((WritableCell)new Number(40, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                            continue block29;
                                        }
                                        ws.addCell((WritableCell)new Number(41, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    wlydArea += dltbArea;
                                    syArea += dltbArea;
                                    if (lastCode < 3) {
                                        ws.addCell((WritableCell)new Number(43 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    if (lastCode == 5) {
                                        ws.addCell((WritableCell)new Number(46, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    if (lastCode == 6) {
                                        ws.addCell((WritableCell)new Number(47, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    if (lastCode != 9) continue block29;
                                    ws.addCell((WritableCell)new Number(48, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 12: {
                                    if (lastCode == 2 || lastCode == 3) {
                                        nydArea += dltbArea;
                                        ws.addCell((WritableCell)new Number(22 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                        continue block29;
                                    }
                                    wlydArea += dltbArea;
                                    qtArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(47 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                    continue block29;
                                }
                                case 20: {
                                    jsydArea += dltbArea;
                                    czgkydArea += dltbArea;
                                    ws.addCell((WritableCell)new Number(27 + lastCode, startRow + j, dltbArea, (CellFormat)JxlCellUtils.getNumberCell()));
                                }
                            }
                        }
                        ws.addCell((WritableCell)new Label(2, startRow + j, qsdwmc, (CellFormat)cellFormat));
                        ws.addCell((WritableCell)new Number(3, startRow + j, qsdwarea, (CellFormat)JxlCellUtils.getNumberCell()));
                        if (j == arr.size() - 1) {
                            ws.addCell((WritableCell)new Label(2, startRow + j + 1, "\u5c0f\u8ba1", (CellFormat)cellFormat));
                            ws.addCell((WritableCell)new Number(3, startRow + j + 1, area, (CellFormat)JxlCellUtils.getNumberCell()));
                        }
                        xzjsydArea = nydArea + wlydArea;
                        System.out.println("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef:" + xzjsydArea);
                        System.out.println("\u5efa\u8bbe\u7528\u5730\u9762\u79ef:" + jsydArea);
                        System.out.println("\u672a\u5229\u7528\u5730\u9762\u79ef:" + wlydArea);
                        System.out.println("\u519c\u7528\u5730\u9762\u79ef:" + nydArea);
                        ws.addCell((WritableCell)new Number(4, startRow + j, xzjsydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(5, startRow + j, nydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(26, startRow + j, jsydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(42, startRow + j, wlydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(6, startRow + j, gdArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(10, startRow + j, ydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(14, startRow + j, ldArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(18, startRow + j, nydArea - gdArea - ydArea - ldArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(27, startRow + j, czgkydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(33, startRow + j, jtysydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(39, startRow + j, slssydArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(43, startRow + j, syArea, (CellFormat)JxlCellUtils.getNumberCell()));
                        ws.addCell((WritableCell)new Number(49, startRow + j, qtArea, (CellFormat)JxlCellUtils.getNumberCell()));
                    }
                    ws.addCell((WritableCell)new Label(1, startRow, qsxz, (CellFormat)cellFormat));
                    ws.mergeCells(1, startRow, 1, startRow + arr.size());
                    startRow += arr.size() + 1;
                }
                ws.mergeCells(0, 5, 0, startRow);
                ws.addCell((WritableCell)new Label(1, startRow, "\u5408\u8ba1", (CellFormat)cellFormat));
                ws.mergeCells(1, startRow, 2, startRow);
                ws.addCell((WritableCell)new Number(3, startRow, allArea, (CellFormat)JxlCellUtils.getNumberCell()));
                for (int col = 4; col <= 54; ++col) {
                    double total = 0.0;
                    for (int row = 5; row <= startRow; ++row) {
                        if (ws.getCell(col, row).getType() == CellType.EMPTY) {
                            ws.addCell((WritableCell)new Label(col, row, "", (CellFormat)cellFormat));
                        } else {
                            Number area = (Number)ws.getCell(col, row);
                            total += area.getValue();
                        }
                        if (row != startRow) continue;
                        ws.addCell((WritableCell)new Number(col, startRow, total, (CellFormat)JxlCellUtils.getNumberCell()));
                    }
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa" + fileName + "excel\u8868\u51fa\u9519\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public void tdghExport() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = "\u89c4\u5212\u60c5\u51b5\u7edf\u8ba1\u8868.xls";
        String unit = this.data.get("unit").toString();
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("sheet1", 0);
            ws.setColumnView(0, 20);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 15);
            ws.setColumnView(3, 15);
            ws.setRowView(1, 350);
            ws.setRowView(2, 350);
            ws.setRowView(3, 350);
            ws.setRowView(4, 700);
            WritableCellFormat cellFormat = JxlCellUtils.getNormolCell();
            ws.addCell((WritableCell)new Label(0, 0, "\u89c4\u5212\u60c5\u51b5\u7edf\u8ba1\u8868", (CellFormat)JxlCellUtils.getHeader()));
            ws.mergeCells(0, 0, 3, 0);
            ws.addCell((WritableCell)new Label(3, 1, "\u5355\u4f4d:" + unit));
            ws.addCell((WritableCell)new Label(0, 2, "\u5141\u8bb8\u5efa\u8bbe\u533a", (CellFormat)cellFormat));
            ws.mergeCells(0, 2, 1, 2);
            ws.addCell((WritableCell)new Label(2, 2, "\u6709\u6761\u4ef6\u5efa\u8bbe\u533a", (CellFormat)cellFormat));
            ws.mergeCells(2, 2, 2, 3);
            ws.addCell((WritableCell)new Label(3, 2, "\u9650\u5236\u5efa\u8bbe\u533a", (CellFormat)cellFormat));
            ws.mergeCells(3, 2, 3, 3);
            ws.addCell((WritableCell)new Label(0, 3, "\u603b\u9762\u79ef", (CellFormat)cellFormat));
            ws.addCell((WritableCell)new Label(1, 3, "\u5176\u4e2d\u65b0\u589e\u5efa\u8bbe\u7528\u5730", (CellFormat)cellFormat));
            JSONArray array = (JSONArray)this.data.get("value");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = (JSONObject)array.get(i);
                if (object.get((Object)"name").equals("\u5141\u8bb8\u5efa\u8bbe\u533a")) {
                    ws.addCell((WritableCell)new Number(0, 4, object.getDouble("value").doubleValue(), (CellFormat)JxlCellUtils.getNumberCell()));
                    continue;
                }
                if (object.get((Object)"name").equals("\u65b0\u589e\u5efa\u8bbe\u7528\u5730")) {
                    ws.addCell((WritableCell)new Number(1, 4, object.getDouble("value").doubleValue(), (CellFormat)JxlCellUtils.getNumberCell()));
                    continue;
                }
                if (object.get((Object)"name").equals("\u6709\u6761\u4ef6\u5efa\u8bbe\u533a")) {
                    ws.addCell((WritableCell)new Number(2, 4, object.getDouble("value").doubleValue(), (CellFormat)JxlCellUtils.getNumberCell()));
                    continue;
                }
                ws.addCell((WritableCell)new Number(3, 4, object.getDouble("value").doubleValue(), (CellFormat)JxlCellUtils.getNumberCell()));
            }
            for (int j = 0; j < 4; ++j) {
                if (ws.getCell(j, 4).getType() != CellType.EMPTY) continue;
                ws.addCell((WritableCell)new Number(j, 4, 0.0, (CellFormat)JxlCellUtils.getNumberCell()));
            }
            ws.insertColumn(0);
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
    }

    public void queryExport() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = this.data.get("title").toString() + ".xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            WritableCellFormat cellFormat = JxlCellUtils.getNormolCell();
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("sheet1", 0);
            JSONArray array = (JSONArray)this.data.get("value");
            Object[] keys = ((JSONObject)array.get(0)).keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i].toString();
                ws.addCell((WritableCell)new Label(i, 0, key, (CellFormat)cellFormat));
            }
            for (int j = 0; j < array.size(); ++j) {
                JSONObject object = (JSONObject)array.get(j);
                for (int k = 0; k < keys.length; ++k) {
                    String key = keys[k].toString();
                    String value = object.get((Object)key).toString();
                    ws.addCell((WritableCell)new Label(k, j + 1, value, (CellFormat)cellFormat));
                    ws.setColumnView(k, 20);
                    ws.setRowView(k, 400);
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
        this.setData(request.getParameter("param"));
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = (Map)JSONObject.parseObject((String)data, Map.class);
    }
}

