/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.map;

import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Configuration;
import com.gtis.emapserver.entity.Service;
import com.gtis.emapserver.service.DictService;
import com.gtis.emapserver.service.MapService;
import com.gtis.emapserver.utils.AppPropertyUtils;
import com.gtis.emapserver.utils.DateUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAction
extends BaseAction {
    private final String ALL_YEAR = "all";
    @Autowired
    private MapService mapService;
    @Autowired
    private DictService dictService;
    private String xzdm;
    private String[] serviceIds;
    private String businessType;
    private String year;
    private String category;
    private String id;
    private String dictId;

    public void services() throws IOException {
        this.sendJson((Object)this.getOperaLayers());
    }

    public void getDict() throws IOException {
        try {
            this.sendJson((Object)this.dictService.getDictById(this.dictId));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void functions() throws IOException {
        HashMap<String, List> funcMap = new HashMap<String, List>();
        for (String serviceId : this.serviceIds) {
            funcMap.put(serviceId, this.mapService.getFunctions(serviceId));
        }
        this.sendJson(funcMap);
    }

    public void config() throws IOException {
        Configuration configuration = this.mapService.getConfig();
        configuration.getMap().setOperationalLayers(this.getOperaLayers());
        this.sendJson((Object)configuration);
    }

    public void regionCodeList() throws IOException {
        try {
            this.sendJson((Object)this.mapService.getRegionCodeList(this.getCurrentRegionCode()));
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            this.sendError(ex.getMessage());
        }
    }

    public void regionShape() throws IOException {
        this.sendString(this.mapService.getRegionShape(this.id));
    }

    private List<Service> getOperaLayers() {
        return this.mapService.getServices(this.getMapCondition());
    }

    private Map<String, Object> getMapCondition() {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("xzdm", this.getCurrentRegionCode());
        if (this.notEmpty(this.serviceIds)) {
            condition.put("serviceIds", this.serviceIds);
        }
        if (this.notBlank(this.businessType)) {
            condition.put("businessType", this.businessType);
        }
        if (!"all".equalsIgnoreCase(this.year)) {
            condition.put("year", this.getYearParam());
        }
        if (this.notBlank(this.category)) {
            condition.put("category", this.category);
        }
        return condition;
    }

    private String getCurrentRegionCode() {
        if (this.notBlank(this.xzdm)) {
            return this.xzdm;
        }
        return this.getDefaultXzdm();
    }

    private String getDefaultXzdm() {
        return (String)AppPropertyUtils.getAppEnv((String)"default.regioncode");
    }

    private String getYearParam() {
        if (this.notBlank(this.year)) {
            return this.year;
        }
        this.year = (String)AppPropertyUtils.getAppEnv((String)"default.year");
        if ("current".equals(this.year)) {
            this.year = DateUtils.getCurrentYear();
        }
        return this.year;
    }

    public String getTheme() {
        return (String)AppPropertyUtils.getAppEnv((String)"emap.theme");
    }

    public void setServiceIds(String serviceIds) {
        this.serviceIds = serviceIds.split(";");
    }

    public void setXzdm(String xzdm) {
        this.xzdm = xzdm;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    private boolean notBlank(String value) {
        return StringUtils.isNotBlank((String)value);
    }

    private boolean notEmpty(String[] value) {
        return ArrayUtils.isNotEmpty((Object[])value);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDictId() {
        return this.dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }
}

