/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.ledger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.Page;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.CLKZD;
import com.gtis.emapserver.entity.DJDK;
import com.gtis.emapserver.entity.Document;
import com.gtis.emapserver.entity.GDDK;
import com.gtis.emapserver.entity.HYDK;
import com.gtis.emapserver.entity.WFYD;
import com.gtis.emapserver.service.DocumentService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.LedgerService;
import com.gtis.emapserver.utils.ArrayUtils;
import com.gtis.emapserver.utils.EnumUtils;
import com.gtis.emapserver.utils.EnvContext;
import com.opensymphony.xwork2.ActionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class LedgerAction
extends BaseAction {
    @Autowired
    private LedgerService ledgerService;
    @Autowired
    private EnvContext envContext;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private GISManager gisManager;
    protected int start;
    protected int limit = 20;
    private Map condition;
    private String fileName;
    private HYDK hydk;
    private WFYD wfyd;
    private GDDK gddk;
    private DJDK djdk;
    private CLKZD clkzd;
    private String[] ids;
    private String startTime;
    private String endTime;
    private String type;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HYDK getHydk() {
        return this.hydk;
    }

    public void setHydk(String hydk) {
        this.hydk = (HYDK)JSON.parseObject((String)hydk, HYDK.class);
    }

    public WFYD getWfyd() {
        return this.wfyd;
    }

    public void setWfyd(String wfyd) {
        this.wfyd = (WFYD)JSON.parseObject((String)wfyd, WFYD.class);
    }

    public GDDK getGddk() {
        return this.gddk;
    }

    public void setGddk(GDDK gddk) {
        this.gddk = gddk;
    }

    public DJDK getDjdk() {
        return this.djdk;
    }

    public void setDjdk(DJDK djdk) {
        this.djdk = djdk;
    }

    public CLKZD getClkzd() {
        return this.clkzd;
    }

    public void setClkzd(CLKZD clkzd) {
        this.clkzd = clkzd;
    }

    public String getIds() {
        return ArrayUtils.join(Arrays.asList(this.ids), (String)",");
    }

    public void setIds(String ids) {
        this.ids = ids.split(",");
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String execute() {
        return this.type;
    }

    public Object getLayerAlias() {
        if (EnumUtils.LedgerType.JCTB.getLtype().equals(this.type)) {
            return this.envContext.getEnv("map.jctb.layer");
        }
        if (EnumUtils.LedgerType.XFQKB.getLtype().equals(this.type)) {
            return this.envContext.getEnv("map.xfdk.layer");
        }
        if (EnumUtils.LedgerType.HYDK.getLtype().equals(this.type)) {
            return this.envContext.getEnv("map.hydk.layer");
        }
        if (EnumUtils.LedgerType.WFYD.getLtype().equals(this.type)) {
            return this.envContext.getEnv("map.wfyd.layer");
        }
        if (EnumUtils.LedgerType.LBGD.getLtype().equals(this.type)) {
            return this.envContext.getEnv("map.lbgd.layer");
        }
        return null;
    }

    public Page list() throws IOException {
        try {
            this.sendJson((Object)this.ledgerService.getLedgerPages(this.start, this.limit, this.condition, this.type));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
        return null;
    }

    public void update() throws IOException {
        boolean success = false;
        try {
            if (!this.isNull((Object)this.hydk)) {
                success = this.ledgerService.update((Object)this.hydk, this.type);
            } else if (!this.isNull((Object)this.wfyd)) {
                success = this.ledgerService.update((Object)this.wfyd, this.type);
            } else if (!this.isNull((Object)this.gddk)) {
                success = this.ledgerService.update((Object)this.gddk, this.type);
            } else if (!this.isNull((Object)this.djdk)) {
                success = this.ledgerService.update((Object)this.djdk, this.type);
            } else if (!this.isNull((Object)this.clkzd)) {
                success = this.ledgerService.update((Object)this.clkzd, this.type);
            }
        }
        catch (Exception e) {
            this.sendError("\u66f4\u65b0\u5f02\u5e38\u3010{" + e.getLocalizedMessage() + "}\u3011");
            this.logger.error("\u66f4\u65b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        if (success) {
            this.sendOk("\u66f4\u65b0\u6210\u529f\uff01");
        } else {
            this.sendError("\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
    }

    public void delete() throws IOException {
        boolean success = false;
        try {
            success = false;
            String layerName = null;
            if (this.type.equalsIgnoreCase(EnumUtils.LedgerType.LBGD.getLtype())) {
                layerName = String.valueOf(this.envContext.getEnv("sde.lbgd.layer"));
            }
            if (this.isNull(layerName)) {
                this.sendError(this.getMessage("layer.not.config", new Object[]{this.type}));
            }
            for (int i = 0; i < this.ids.length; ++i) {
                success = this.gisManager.getGISService().delete(layerName, this.ids[i], null);
            }
        }
        catch (Exception e) {
            this.sendError("\u5220\u9664\u5f02\u5e38\u3010{" + e.getLocalizedMessage() + "}\u3011");
            this.logger.error("\u66f4\u65b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        if (success) {
            this.sendOk("\u5220\u9664\u6210\u529f\uff01");
        } else {
            this.sendError("\u5220\u9664\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
    }

    public void export() throws IOException {
        try {
            Document document = null;
            List entities = this.ledgerService.getLedgerEntities(this.condition, this.type);
            if (entities.size() > 0) {
                document = this.isNull((Object)this.fileName) ? this.documentService.writeExcel(this.ledgerService.getExcelList(entities, this.type)) : this.documentService.writeExcel(this.ledgerService.getExcelMap(entities, this.type), this.fileName);
                this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), document.getFileName());
            } else {
                this.sendError("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public void exportShp() throws IOException {
        try {
            List queryResult;
            List conditions = (List)this.condition.get("condition");
            this.logger.info(JSON.toJSONString((Object)conditions));
            String layerName = null;
            if (this.type.equals(EnumUtils.LedgerType.JCTB.getLtype())) {
                layerName = String.valueOf(this.envContext.getEnv("sde.jctb.layer"));
            }
            if ((queryResult = this.gisManager.getGISService().query(layerName, ArrayUtils.join((List)conditions, (String)" AND "), null, true, null)).size() > 0) {
                CoordinateReferenceSystem crs = this.gisManager.getGISService().getLayerCRS(layerName, null);
                File file = this.gisManager.getGeoService().createShpZip(System.getProperty("java.io.tmpdir").concat("TEMP_" + System.currentTimeMillis()), queryResult, crs);
                if (file.exists()) {
                    this.sendFile(file);
                } else {
                    this.sendError(this.getMessage("shp.zip.error", new Object[0]));
                }
            } else {
                this.sendError("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            }
        }
        catch (IOException e) {
            this.logger.error(this.getMessage("shp.export.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("shp.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public void exportLeger() {
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        Document document = this.ledgerService.exportExcel(this.type, this.startTime, this.endTime);
        try {
            this.sendDocument(response, document);
        }
        catch (IOException e) {
            this.logger.error("\u5bfc\u51fa\u5b58\u5728IO\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setCondition(String value) {
        this.condition = new HashMap();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        ArrayList<String> conditions = new ArrayList<String>();
        JSONArray conJson = JSON.parseArray((String)value);
        for (Object obj : conJson) {
            conditions.add(this.seriCondition((JSONObject)obj));
        }
        this.condition.put("condition", conditions);
    }

    public Map getCondition() {
        return this.condition;
    }

    private String seriCondition(JSONObject item) {
        String condition = item.getString("field").concat(" ").concat(item.getString("condition").concat(" "));
        condition = item.getString("condition").equalsIgnoreCase("like") ? condition.concat("'%").concat(item.getString("value").concat("%'")) : condition.concat(item.getString("value"));
        return condition;
    }
}

