/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.alibaba.fastjson.JSON;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.BgdcRecord;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.service.DictService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.WorkflowService;
import com.gtis.emapserver.utils.EnumUtils;
import com.gtis.emapserver.utils.EnvContext;
import com.gtis.plat.vo.UserInfo;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowAction
extends BaseAction {
    private static final String WF_KEY_PROID = "proid";
    @Autowired
    private EnvContext envContext;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private DictService dictService;
    private String type;
    private String proid;
    private String layerName;
    private Map columns;
    private String dataSource;
    private String pk;
    private String eventName;
    private int state;
    private String activityid;
    private String wdid;
    private Map workflow;
    private UserInfo currentUser;
    private String currentOrganName;
    private List<Map> jctbList;
    private BgdcRecord record;

    public String create() throws IOException {
        try {
            assert (this.wdid != null);
            this.workflow = this.workflowService.getWorkFlowByWdid(this.wdid);
            this.currentOrganName = this.envContext.getCurrentOrganName();
            this.currentUser = this.envContext.getCurrentUser();
            if (!this.isNull((Object)this.type) && this.type.equals(EnumUtils.WFType.BGDC.getWtype())) {
                this.jctbList = this.gisManager.getGISService().query(String.valueOf(this.envContext.getEnv("sde.jctb.layer")), "1=1", new String[]{"JCBH", "PROID"}, false, null);
                if (!this.isNull((Object)this.jctbList) && this.jctbList.size() > 0) {
                    Collections.sort(this.jctbList, new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return "success";
    }

    public void saveTask() throws IOException {
        boolean success = false;
        try {
            Map parameterMap = ServletActionContext.getRequest().getParameterMap();
            String[] params = (String[])parameterMap.get("data");
            String data = params[0];
            if (!this.isNull((Object)data)) {
                success = this.workflowService.createTask(data);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getMessage());
        }
        if (success) {
            this.sendOk(this.getMessage("task.create.success", new Object[0]));
        } else {
            this.sendError(this.getMessage("task.create.error", new Object[0]));
        }
    }

    public String viewForm() throws IOException {
        assert (this.type != null);
        assert (this.proid != null);
        if (EnumUtils.WFType.BGDC.getWtype().equals(this.type)) {
            this.record = this.workflowService.findBgdcRecord(this.proid);
            if (this.isNull((Object)this.record)) {
                this.record = new BgdcRecord();
                Dict jctbDict = this.dictService.getDictById(this.proid);
                if (this.isNull((Object)jctbDict)) {
                    throw new RuntimeException("not find record!");
                }
                String jcbh = jctbDict.getName();
                this.jctbList = this.gisManager.getGISService().query(String.valueOf(this.envContext.getEnv("sde.jctb.layer")), "JCBH='" + jcbh + "'", null, true, null);
                this.record.setProid(this.proid);
                this.record.setJcbh(jcbh);
                if (!this.isNull((Object)this.jctbList) && this.jctbList.size() > 0) {
                    Map item = (Map)this.jctbList.get(0);
                    this.record.setJcmj(MapUtils.getDoubleValue((Map)item, (Object)"JCMJ", (double)0.0));
                    this.record.setTblx(MapUtils.getString((Map)item, (Object)"TBLX"));
                    String geometry = MapUtils.getString((Map)item, (Object)"SHAPE");
                    this.record.setFhghmj(MapUtils.getDoubleValue((Map)item, (Object)"YXJSQ", (double)0.0));
                    this.record.setBfhghmj(MapUtils.getDoubleValue((Map)item, (Object)"XZJSQ", (double)0.0));
                    List analysisResult = this.gisManager.getGISService().intersect(String.valueOf(this.envContext.getEnv("sde.dltb.layer")), geometry, null, "");
                    this.logger.info("[jctb analysis:]" + JSON.toJSONString((Object)analysisResult));
                    if (!this.isNull((Object)analysisResult) && analysisResult.size() > 0) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Map map : analysisResult) {
                            if (analysisResult.indexOf(map) != 0) {
                                stringBuilder.append(",");
                            }
                            String zl = MapUtils.getString((Map)map, (Object)String.valueOf(this.envContext.getEnv("dltb.tdzl.field")).trim());
                            stringBuilder.append(zl);
                        }
                        if (stringBuilder.length() > 0) {
                            this.record.setDltbzl(stringBuilder.toString());
                        }
                    }
                }
            }
        }
        return "form";
    }

    public void saveForm() throws IOException {
        boolean success = false;
        try {
            success = this.workflowService.saveBgdcRecord(this.record);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("form.save.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("form.save.error", new Object[]{e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.sendOk(this.getMessage("form.save.success", new Object[0]));
        } else {
            this.sendError(this.getMessage("form.save.error", new Object[]{"\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7"}));
        }
    }

    public void location() throws IOException {
        try {
            HttpServletResponse response = ServletActionContext.getResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("layerAlias", this.getLayerAlias());
            params.put("where", "proid = '" + this.proid + "'");
            response.sendRedirect("/emapserver/map/map.action?hideSysmenu=true&action=location&params=".concat(URLEncoder.encode(JSON.toJSONString(params), "utf-8").replaceAll("\\+", "")));
        }
        catch (IOException e) {
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void editPlot() throws IOException {
        boolean success = false;
        try {
            success = this.workflowService.editPlot(this.proid, this.type, this.pk, this.layerName, this.dataSource, this.columns);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.sendOk(this.getMessage("edit.success", new Object[0]));
        } else {
            this.sendError(this.getMessage("edit.error.log", new Object[0]));
        }
    }

    public void changeState() throws IOException {
        boolean success = false;
        try {
            success = this.workflowService.changeState(this.proid, this.envContext.getEnv("state.field.name").toString(), this.layerName, this.dataSource, this.activityid);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("state.change.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("state.change.error", new Object[]{e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.logger.info(this.getMessage("state.change.success", new Object[0]));
        } else {
            this.logger.error(this.getMessage("state.change.error", new Object[]{this.proid}));
        }
    }

    public void delete() throws Exception {
        boolean success = false;
        try {
            success = this.workflowService.delete(this.proid, this.type, this.layerName);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("delete.error", new Object[]{this.type, e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.logger.info(this.getMessage("delete.success", new Object[0]));
        } else {
            this.logger.info(this.getMessage("delete.error", new Object[]{this.type}));
        }
    }

    public Object getLayerAlias() {
        if (this.type.equals(EnumUtils.WFType.XFDJ.getWtype())) {
            return this.envContext.getEnv("map.xfdk.layer");
        }
        if (this.type.equals(EnumUtils.WFType.XXGK.getWtype())) {
            return this.envContext.getEnv("map.xxgk.layer");
        }
        if (this.type.equals(EnumUtils.WFType.BGDC.getWtype())) {
            return this.envContext.getEnv("map.jctb.layer");
        }
        if (this.type.equals(EnumUtils.WFType.YDXC.getWtype())) {
            return this.envContext.getEnv("map.ydxc.layer");
        }
        if (this.type.equals(EnumUtils.WFType.ZFXC.getWtype())) {
            return this.envContext.getEnv("map.wfyd.layer");
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public String getProid() {
        return this.proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public void setColumns(String value) {
        try {
            this.columns = (Map)JSON.parseObject((String)value, Map.class);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.columns.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getActivityid() {
        return this.activityid;
    }

    public void setActivityid(String activityid) {
        this.activityid = activityid;
    }

    public String getWdid() {
        return this.wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public Map getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Map workflow) {
        this.workflow = workflow;
    }

    public UserInfo getCurrentUser() {
        return this.currentUser;
    }

    public String getCurrentOrganName() {
        return this.currentOrganName;
    }

    public List getJctbList() {
        return this.jctbList;
    }

    public BgdcRecord getRecord() {
        return this.record;
    }

    public void setRecord(String record) {
        this.record = (BgdcRecord)JSON.parseObject((String)record, BgdcRecord.class);
    }
}

