/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.Page;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Monitor;
import com.gtis.emapserver.entity.Summary;
import com.gtis.emapserver.service.MonitorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorAction
extends BaseAction {
    @Autowired
    private MonitorService monitorService;
    private String username;
    private String rolename;
    private Monitor monitor;
    protected int start;
    protected int limit = 20;
    private Map condition;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRolename() {
        return this.rolename;
    }

    public void setRolename(String rolename) {
        this.rolename = rolename;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMonitor(String value) {
        try {
            JSONObject object = JSON.parseObject((String)value);
            this.monitor = new Monitor();
            this.monitor.setOperaDetail(String.valueOf(object.get((Object)"operadetail")));
            this.monitor.setOperaType(String.valueOf(object.get((Object)"operatype")));
            this.monitor.setRoleName(String.valueOf(object.get((Object)"rolename")));
            this.monitor.setUserName(String.valueOf(object.get((Object)"username")));
            this.monitor.setBz(String.valueOf(object.get((Object)"bz")));
            this.monitor.setOperaTime(new Date());
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790monitor\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public void insert() throws IOException {
        try {
            this.monitorService.insert(this.monitor);
            this.sendOk("\u63d2\u5165\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u63d2\u5165\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u63d2\u5165\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public Page<Monitor> list() throws IOException {
        try {
            this.sendJson((Object)this.monitorService.getPages(this.start, this.limit, this.condition));
        }
        catch (IOException e) {
            this.sendJson((Object)new Page());
        }
        return null;
    }

    public List<Summary> getSummary() throws IOException {
        return this.monitorService.sumByUser();
    }

    public List<Map> getStock() {
        List summaryList = this.monitorService.sumByDate();
        ArrayList<Map> stockList = new ArrayList<Map>();
        for (Summary summary : summaryList) {
            String[] strings = summary.getName().split("-");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("year", strings[0]);
            map.put("month", strings[1]);
            map.put("day", strings[2]);
            map.put("count", summary.getCount());
            stockList.add(map);
        }
        return stockList;
    }

    public Map getStartDate() {
        List list = this.monitorService.sumByDate();
        Summary summary = (Summary)list.get(0);
        String[] strings = summary.getName().split("-");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("year", strings[0]);
        map.put("month", strings[1]);
        map.put("day", strings[2]);
        return map;
    }

    public void setCondition(String value) {
        this.condition = new HashMap();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        ArrayList<String> conditions = new ArrayList<String>();
        JSONArray conJson = JSON.parseArray((String)value);
        for (Object obj : conJson) {
            conditions.add(this.seriCondition((JSONObject)obj));
        }
        this.condition.put("condition", conditions);
    }

    public Map getCondition() {
        return this.condition;
    }

    private String seriCondition(JSONObject item) {
        String condition = item.getString("field").concat(" ").concat(item.getString("condition").concat(" "));
        condition = item.getString("condition").equalsIgnoreCase("like") ? condition.concat("'%").concat(item.getString("value").concat("%'")) : condition.concat(item.getString("value"));
        return condition;
    }
}

