/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Monitor;
import com.gtis.emapserver.service.MonitorService;
import com.gtis.emapserver.service.PermissionService;
import com.gtis.emapserver.utils.AppPropertyUtils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexAction
extends BaseAction {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private MonitorService monitorService;

    public String execute() throws Exception {
        Monitor monitor = new Monitor();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String userId = SessionUtil.getCurrentUserId();
        List pfRoleVos = this.userService.getRoleListByUser(userId);
        List pfOrganVos = this.userService.getOrganListByUser(userId);
        StringBuilder sbRoleName = new StringBuilder();
        StringBuilder sbOrganName = new StringBuilder();
        for (int i = 0; i < pfRoleVos.size(); ++i) {
            PfRoleVo roleVo = (PfRoleVo)pfRoleVos.get(i);
            sbRoleName.append(roleVo.getRoleName());
            if (i == pfRoleVos.size() - 1) continue;
            sbRoleName.append(",");
        }
        for (int j = 0; j < pfOrganVos.size(); ++j) {
            PfOrganVo organVo = (PfOrganVo)pfOrganVos.get(j);
            sbOrganName.append(organVo.getOrganName());
            if (j == pfOrganVos.size() - 1) continue;
            sbOrganName.append(",");
        }
        monitor.setOrganName(sbOrganName.toString());
        monitor.setRoleName(sbRoleName.toString());
        monitor.setOperaTime(new Date());
        monitor.setUserName(userInfo.getUsername());
        monitor.setOperaType(Monitor.Type.LOGIN.getName());
        this.monitorService.insert(monitor);
        return super.execute();
    }

    public UserInfo getUser() {
        return SessionUtil.getCurrentUser();
    }

    public String getTheme() {
        return (String)AppPropertyUtils.getAppEnv((String)"emap.theme");
    }

    @Action(value="/jsoneditor")
    public String jsonEditor() {
        return "jsoneditor";
    }
}

