/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.gtis.emapserver.core.service.FileStoreService;
import com.gtis.emapserver.core.web.BaseAction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class FileAction
extends BaseAction {
    @Autowired
    private FileStoreService fileStoreService;
    private String id;
    private String fileName;

    public void upload() throws IOException {
        this.logger.info("----File Upload----");
        HttpServletRequest request = ServletActionContext.getRequest();
        try {
            if (StringUtils.isNotBlank((String)this.fileName)) {
                this.fileStoreService.save(request, this.id, this.fileName);
            } else {
                this.fileStoreService.save(request, this.id);
            }
            this.sendOk("\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public void fileIds() throws IOException {
        try {
            this.sendSuccess((Object)this.fileStoreService.getFileIds(this.id));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6ID\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u83b7\u53d6\u6587\u4ef6ID\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public void fileNames() throws IOException {
        try {
            this.sendSuccess((Object)this.fileStoreService.getFileNames(this.id));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public void fileName() throws IOException {
        try {
            File file = this.fileStoreService.getFile(this.id);
            this.sendSuccess((Object)file.getName());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
    }

    public void file() throws IOException {
        try {
            this.sendFile(this.fileStoreService.getFile(this.id));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void thumb() throws IOException {
        try {
            this.sendFile(this.fileStoreService.getThumb(this.id));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void delete() throws IOException {
        try {
            this.fileStoreService.delete(this.id);
            this.sendOk("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws Exception {
        this.logger.info("----File Download----");
        HttpServletRequest request = ServletActionContext.getRequest();
        String fileName = "\u5750\u6807\u4e32.txt";
        File file = this.fileStoreService.getNewFile(fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(request.getParameter("param"));
        bufferedWriter.flush();
        bufferedWriter.close();
        ServletActionContext.getResponse().setContentType("application/x-download");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
        ServletActionContext.getResponse().setContentLength((int)file.length());
        if (file.exists() && file.canRead()) {
            byte[] buffer = new byte[4096];
            BufferedOutputStream output = null;
            BufferedInputStream input = null;
            try {
                output = new BufferedOutputStream((OutputStream)os);
                input = new BufferedInputStream(new FileInputStream(file));
                int n = -1;
                while ((n = input.read(buffer, 0, 4096)) > -1) {
                    output.write(buffer, 0, n);
                }
                ServletActionContext.getResponse().flushBuffer();
            }
            catch (Exception e) {
                this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            }
            finally {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
        }
    }

    public void setId(String id) {
        this.logger.debug("id:[{}]", (Object)id);
        this.id = id;
    }

    public void setFileName(String fileName) {
        this.logger.debug("fileName:[{}]", (Object)fileName);
        this.fileName = fileName;
    }
}

