/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.emapserver.dao.BgdcRecordDao;
import com.gtis.emapserver.entity.BgdcRecord;
import com.gtis.emapserver.entity.Xfqkb;
import com.gtis.emapserver.entity.Xxgksqs;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.service.DictService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.LedgerService;
import com.gtis.emapserver.service.WorkflowService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.EnumUtils;
import com.gtis.emapserver.utils.UUIDGenerator;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WorkflowServiceImpl
extends BaseLogger
implements WorkflowService {
    private static final String WF_KEY_PROID = "proid";
    private static final String STATE_NEW = "\u65b0\u5efa";
    private static final String STATE_REPORT = "\u4e0a\u62a5";
    private static final String STATE_SETTLE = "\u529e\u7ed3";
    private static final String STATE_BACK = "\u9000\u56de";
    private static final String SE_OBJECTID_FIELD = "OBJECTID";
    @Autowired
    private GISManager gisManager;
    @Autowired
    private LedgerService ledgerService;
    @Autowired
    private WorkFlowCoreService workFlowCoreService;
    @Autowired
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private DictService dictService;
    @Autowired
    private BgdcRecordDao bgdcRecordDao;

    public Map getWorkFlowByWdid(String wdid) {
        PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        if (this.isNull((Object)pfWorkFlowDefineVo)) {
            throw new RuntimeException("can't find workflow wdid" + wdid + "please check!");
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("workInfo", pfWorkFlowDefineVo);
        info.put("businessInfo", this.sysWorkFlowDefineService.getBusiness(pfWorkFlowDefineVo.getBusinessId()));
        return info;
    }

    public boolean createTask(String data) throws Exception {
        boolean success = false;
        try {
            JSONObject taskData = JSON.parseObject((String)data);
            String userId = SessionUtil.getCurrentUser().getId();
            String jcbh = MapUtils.getString((Map)taskData, (Object)"jcbh");
            PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();
            wfVO.setCreateTime(new Date());
            wfVO.setTimeLimit(MapUtils.getIntValue((Map)taskData, (Object)"timeLimit", (int)1));
            wfVO.setRemark(MapUtils.getString((Map)taskData, (Object)"remark"));
            wfVO.setCreateUser(userId);
            wfVO.setWorkflowIntanceName(MapUtils.getString((Map)taskData, (Object)"instanceName"));
            wfVO.setWorkflowDefinitionId(MapUtils.getString((Map)taskData, (Object)"wdid"));
            String uuid = UUIDGenerator.generate();
            wfVO.setWorkflowIntanceId(uuid);
            wfVO.setProId(uuid);
            this.workFlowCoreService.createWorkFlowInstance(wfVO, userId);
            Dict dict = new Dict();
            dict.setId(uuid);
            dict.setName(jcbh);
            this.dictService.saveDict(dict);
            success = true;
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean editPlot(String proid, String type, String primaryKey, String layerName, String dataSource, Map<String, Object> columns) {
        if (this.isNull((Object)proid) || this.isNull((Object)type)) {
            return false;
        }
        boolean success = false;
        try {
            HashMap<String, String> proMap = new HashMap<String, String>();
            if (type.equals(EnumUtils.WFType.XFDJ.getWtype())) {
                Xfqkb xfqkb = this.ledgerService.findXfqkb(proid);
                proMap.put(WF_KEY_PROID, xfqkb.getProjectId());
                this.entity2Map((Object)xfqkb, proMap);
            } else if (type.equals(EnumUtils.WFType.XXGK.getWtype())) {
                Xxgksqs xxgksqs = this.ledgerService.findXxgksqs(proid);
                proMap.put(WF_KEY_PROID, xxgksqs.getProjectId());
                this.entity2Map((Object)xxgksqs, proMap);
            } else {
                proMap.put(WF_KEY_PROID.toUpperCase(), proid);
            }
            if (!proMap.isEmpty()) {
                columns.putAll(proMap);
            }
            success = this.isNull((Object)primaryKey) ? this.gisManager.getGISService().insert(layerName, columns, dataSource) : this.gisManager.getGISService().update(layerName, primaryKey, columns, dataSource);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
        }
        return success;
    }

    public boolean changeState(String proid, String stateField, String layerName, String dataSource, String activityId) {
        boolean success = false;
        int state = 0;
        if (this.isNull((Object)proid)) {
            return false;
        }
        assert (activityId != null);
        PfActivityVo pfActivityVo = this.sysTaskService.getActivity(activityId);
        String name = pfActivityVo.getActivityName();
        if (!this.isNull((Object)name) && name.equals(STATE_NEW)) {
            state = 1;
        }
        if (!this.isNull((Object)name) && name.equals("\u5ba1\u6838")) {
            state = 2;
        }
        try {
            String where = "proid= '" + proid + "'";
            List results = this.gisManager.getGISService().query(layerName, where, null, false, dataSource);
            if (results.size() == 0) {
                this.logger.warn(this.getMessage("query.none", new Object[]{proid}));
                return false;
            }
            HashMap<String, String> columns = new HashMap<String, String>();
            switch (state) {
                case 0: {
                    columns.put(stateField, STATE_NEW);
                    break;
                }
                case 1: {
                    columns.put(stateField, STATE_REPORT);
                    break;
                }
                case 2: {
                    columns.put(stateField, STATE_SETTLE);
                    break;
                }
                case 3: {
                    columns.put(stateField, STATE_BACK);
                }
            }
            for (int i = 0; i < results.size(); ++i) {
                Map item = (Map)results.get(i);
                String pk = MapUtils.getString((Map)item, (Object)SE_OBJECTID_FIELD);
                success = this.gisManager.getGISService().update(layerName, pk, columns, dataSource);
            }
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public boolean delete(String proid, String type, String layerName) {
        boolean success = false;
        if (this.isNull((Object)proid)) {
            return false;
        }
        assert (type != null);
        try {
            if (EnumUtils.WFType.BGDC.getWtype().equals(type)) {
                return this.deleteBgdcRecord(proid);
            }
            if (type.equals(EnumUtils.WFType.XFDJ.getWtype())) {
                success = this.ledgerService.delete(proid, EnumUtils.LedgerType.XFQKB.getLtype());
            } else if (type.equals(EnumUtils.WFType.XXGK.getWtype())) {
                success = this.ledgerService.delete(proid, EnumUtils.WFType.XXGK.getWtype());
            }
            String where = "proid= '" + proid + "'";
            List queryResults = this.gisManager.getGISService().query(layerName, where, null, false, null);
            if (queryResults.size() == 0) {
                this.logger.info(this.getMessage("query.none", new Object[]{proid}));
                return success;
            }
            for (int i = 0; i < queryResults.size(); ++i) {
                Map item = (Map)queryResults.get(i);
                String pk = MapUtils.getString((Map)item, (Object)SE_OBJECTID_FIELD);
                success = this.gisManager.getGISService().delete(layerName, pk, null);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }

    public boolean deleteBgdcRecord(String proid) {
        boolean success = false;
        if (this.isNull((Object)proid)) {
            return success;
        }
        try {
            this.bgdcRecordDao.delete((Serializable)((Object)proid));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }

    public BgdcRecord findBgdcRecord(String proid) {
        return (BgdcRecord)this.bgdcRecordDao.find((Serializable)((Object)proid));
    }

    public boolean saveBgdcRecord(BgdcRecord bgdcRecord) {
        boolean success = false;
        if (this.isNull((Object)bgdcRecord)) {
            return success;
        }
        try {
            if (this.isNull((Object)this.findBgdcRecord(bgdcRecord.getProid()))) {
                this.bgdcRecordDao.insert((Object)bgdcRecord);
            } else {
                this.bgdcRecordDao.update((Object)bgdcRecord);
            }
            success = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return success;
    }

    private String getWfRemark(String wiid, String activityId) {
        Element root;
        Node node1;
        String activityDesc;
        PfActivityVo pfActivityVo = this.sysTaskService.getActivity(activityId);
        String activityDefinitionId = pfActivityVo.getActivityDefinitionId();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)this.sysWorkFlowInstanceService.getWorkflowInstanceXml(wiid));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!this.isNull(document) && !this.isNull((Object)(activityDesc = (node1 = (root = document.getRootElement()).selectSingleNode("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity[@Id='" + activityDefinitionId + "']/Description")).getText()))) {
            return activityDesc;
        }
        return null;
    }

    public void entity2Map(Object entity, Map desMap) throws IllegalAccessException {
        if (this.isNull(entity) || this.isNull((Object)desMap)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Class<?> c = entity.getClass();
            List<Field> fields = Arrays.asList(c.getDeclaredFields());
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                field.setAccessible(true);
                Object value = field.get(entity);
                if (this.isNull(value) || value.equals(0.0)) continue;
                if (field.getType().equals(Date.class)) {
                    desMap.put(field.getName().toUpperCase(), sdf.format(value));
                    continue;
                }
                desMap.put(field.getName().toUpperCase(), value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

