/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.common.Page;
import com.gtis.emapserver.dao.GDDKDao;
import com.gtis.emapserver.entity.DJDK;
import com.gtis.emapserver.entity.Document;
import com.gtis.emapserver.entity.GDDK;
import com.gtis.emapserver.service.DocumentService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.WarnService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.EnumUtils;
import com.gtis.emapserver.utils.EnvContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WarnServiceImpl
extends BaseLogger
implements WarnService {
    @Autowired
    private GDDKDao gddkDao;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private EnvContext envContext;
    @Autowired
    private DocumentService documentService;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public Page<GDDK> getPages(int start, int limit, Map<String, ?> condition, String type) {
        assert (type != null);
        try {
            if (EnumUtils.WarnType.IDLELAND.getWtype().equals(type)) {
                return this.gddkDao.getIdleLandPages(start, limit, condition);
            }
            if (EnumUtils.WarnType.ILLEGALENTERPRISE.getWtype().equals(type)) {
                return this.gddkDao.getIllegalEnterprisePages(start, limit, condition);
            }
            if (EnumUtils.WarnType.MORTGAGEEXPIRE.getWtype().equals(type)) {
                return this.gddkDao.getMortgageExpirePages(start, limit, condition);
            }
            if (EnumUtils.WarnType.LACKUSELAND.getWtype().equals(type)) {
                return this.gddkDao.getLackUserLandPages(start, limit, condition);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String update(Object obj, String type) {
        try {
            if (EnumUtils.WarnType.IDLELAND.getWtype().equals(type)) {
                return this.updateIdleLand((GDDK)obj);
            }
            if (EnumUtils.WarnType.ILLEGALENTERPRISE.getWtype().equals(type)) {
                return this.updateIllegalEnterprise((GDDK)obj);
            }
            if (EnumUtils.WarnType.MORTGAGEEXPIRE.getWtype().equals(type)) {
                return this.updateMortgageExpire((DJDK)obj);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public int count(String type, Map<String, ?> condition) {
        try {
            if (EnumUtils.WarnType.IDLELAND.getWtype().equals(type)) {
                return this.gddkDao.countIdleLand(condition);
            }
            if (EnumUtils.WarnType.ILLEGALENTERPRISE.getWtype().equals(type)) {
                return this.gddkDao.countIllegalEnterprise(condition);
            }
            if (EnumUtils.WarnType.MORTGAGEEXPIRE.getWtype().equals(type)) {
                return this.gddkDao.countMortgageExpire(condition);
            }
            if (EnumUtils.WarnType.LACKUSELAND.getWtype().equals(type)) {
                return this.gddkDao.countLackUseLand(condition);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public boolean update2(Object obj, String type) {
        boolean success = false;
        Map<String, String> map = new HashMap<String, Object>();
        try {
            if (type.equals(EnumUtils.WarnType.IDLELAND.getWtype()) || type.equals(EnumUtils.WarnType.ILLEGALENTERPRISE.getWtype())) {
                GDDK gddk = (GDDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.gddk.layer"));
                if (type.equals(EnumUtils.WarnType.IDLELAND.getWtype())) {
                    map.put("SJKGSJ", sdf.format(gddk.getSjkgsj()));
                    map.put("SJJGSJ", sdf.format(gddk.getSjjgsj()));
                } else {
                    map = gddk.toMap();
                }
                success = this.gisManager.getGISService().update(layerName, gddk.getObjectId(), map, null);
            } else {
                DJDK djdk = (DJDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.djdk.layer"));
                map.put("DYJE", (String)((Object)Double.valueOf(djdk.getDyje())));
                if (!this.isNull((Object)djdk.getDydqsj())) {
                    map.put("DYDQSJ", sdf.format(djdk.getDydqsj()));
                }
                map.put("DYLX", djdk.getDylx());
                success = this.gisManager.getGISService().update(layerName, djdk.getObjectId(), map, null);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }

    public String updateIdleLand(GDDK gddk) {
        this.gddkDao.updateIdleLand(gddk);
        return gddk.getObjectId();
    }

    public String updateIllegalEnterprise(GDDK gddk) {
        this.gddkDao.updateIllegalEnterprise(gddk);
        return gddk.getObjectId();
    }

    public String updateMortgageExpire(DJDK djdk) {
        this.gddkDao.updateMortgageExpire(djdk);
        return djdk.getObjectId();
    }

    public Document exportExcel(String type) {
        double zmj;
        List datas = new ArrayList();
        Document document = null;
        HashMap<String, Object> info = new HashMap<String, Object>();
        HashMap condition = new HashMap();
        ArrayList<String> lists = new ArrayList<String>();
        String tplName = type.concat(".xml");
        if (type.equals(EnumUtils.WarnType.IDLELAND.getWtype())) {
            lists.add("      (DG_SJ-current_date<=30 and DG_SJ-current_date>=0 and SJ_DG_SJ is null)\n        or(current_date >DG_SJ and JG_SJ-current_date  <=30 and JG_SJ-current_date>=0 and SJ_DG_SJ is null )\n        or (JG_SJ-current_date>=0 and JG_SJ-current_date<=30 and SJ_JG_SJ is null and SFJC=0 and JSZT='\u5efa\u6210\u9762\u79ef\u4e0d\u8db31/3')\n        or(current_date >JG_SJ and SJ_JG_SJ is null and SFJC=0 and JSZT='\u5efa\u6210\u9762\u79ef\u4e0d\u8db31/3')");
            condition.put("condition", lists);
            datas = this.gddkDao.getGDDKEntities(condition);
            zmj = 0.0;
            for (Object gddk : datas) {
                zmj += ((GDDK)gddk).getMj();
            }
            info.put("idleLands", datas);
            info.put("zmj", zmj);
        } else if (type.equals(EnumUtils.WarnType.LACKUSELAND.getWtype())) {
            lists.add("(SJ_JG_SJ is null and SJ_DG_SJ is not null and SFJC=0 and JSZT='\u5efa\u6210\u9762\u79ef\u4e0d\u8db31/3')");
            condition.put("condition", lists);
            datas = this.gddkDao.getGDDKEntities(condition);
            zmj = 0.0;
            for (Object gddk : datas) {
                zmj += ((GDDK)gddk).getMj();
            }
            info.put("zmj", zmj);
            info.put("lackUseLands", datas);
        }
        try {
            document = this.documentService.renderExcel(info, tplName);
            document.setType(Document.Type.xls);
            if (type.equals(EnumUtils.WarnType.IDLELAND.getWtype())) {
                document.setName("\u7a7a\u95f2\u571f\u5730\u9884\u8b66\u7edf\u8ba1\u8868");
            } else if (type.equals(EnumUtils.WarnType.LACKUSELAND.getWtype())) {
                document.setName("\u7528\u800c\u4e0d\u8db3\u571f\u5730\u9884\u8b66\u7edf\u8ba1\u8868");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u9519\u8bef\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return document;
    }
}

