/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.dao.PermissionDao;
import com.gtis.emapserver.entity.Permission;
import com.gtis.emapserver.service.PermissionService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="permissionService")
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private PermissionDao permissionDao;

    public void grant(Permission[] permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission perm : permissions) {
            this.permissionDao.insert((Object)perm);
        }
    }

    public void revoke(Permission[] permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission perm : permissions) {
            if (!StringUtils.isNotBlank((String)perm.getId())) continue;
            this.permissionDao.delete((Serializable)((Object)perm.getId()));
        }
    }

    public boolean hasPermission(String resourcekey, String roleId, String operation) {
        List perms = this.getPermissions(resourcekey, roleId, operation);
        return perms.size() > 0;
    }

    public boolean hasPermission(String resourcekey, String operation) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.isAdmin()) {
            return true;
        }
        String roleIds = userInfo.getRoleIds();
        if (StringUtils.isBlank((String)roleIds)) {
            return false;
        }
        for (String roleId : roleIds.split(",")) {
            if (!this.hasPermission(resourcekey, roleId = roleId.substring(1, roleId.length() - 1), operation)) continue;
            return true;
        }
        return false;
    }

    public List<Permission> getPermissions(String resourceKey, String roleId) {
        return this.getPermissions(resourceKey, roleId, null);
    }

    public List<String> getPermsModels(String roleId) {
        List permissions = this.getPermissions(null, roleId);
        ArrayList<String> perms = new ArrayList<String>();
        for (Permission permission : permissions) {
            if (perms.contains(permission.getResourceKey())) continue;
            perms.add(permission.getResourceKey());
        }
        return perms;
    }

    private List<Permission> getPermissions(String resourceKey, String roleId, String operation) {
        Permission permission = new Permission(resourceKey, roleId, operation);
        return this.permissionDao.getPermissions(permission);
    }
}

