/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.common.Page;
import com.gtis.emapserver.dao.CLKZDDao;
import com.gtis.emapserver.dao.GDDKDao;
import com.gtis.emapserver.dao.HYDKDao;
import com.gtis.emapserver.dao.JCTBDao;
import com.gtis.emapserver.dao.KCZYDao;
import com.gtis.emapserver.dao.LBGDDao;
import com.gtis.emapserver.dao.WFYDDao;
import com.gtis.emapserver.dao.XfqkbDao;
import com.gtis.emapserver.dao.XxgksqsDao;
import com.gtis.emapserver.dao.ZDDKDao;
import com.gtis.emapserver.entity.CLKZD;
import com.gtis.emapserver.entity.DJDK;
import com.gtis.emapserver.entity.Document;
import com.gtis.emapserver.entity.GDDK;
import com.gtis.emapserver.entity.HYDK;
import com.gtis.emapserver.entity.JCTB;
import com.gtis.emapserver.entity.WFYD;
import com.gtis.emapserver.entity.Xfqkb;
import com.gtis.emapserver.entity.Xxgksqs;
import com.gtis.emapserver.service.DocumentService;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.LedgerService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.EnumUtils;
import com.gtis.emapserver.utils.EnvContext;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class LedgerServiceImpl
extends BaseLogger
implements LedgerService {
    @Autowired
    private JCTBDao jctbDao;
    @Autowired
    private XfqkbDao xfqkbDao;
    @Autowired
    private XxgksqsDao xxgksqsDao;
    @Autowired
    private WFYDDao wfydDao;
    @Autowired
    private HYDKDao hydkDao;
    @Autowired
    private LBGDDao lbgdDao;
    @Autowired
    private GDDKDao gddkDao;
    @Autowired
    private CLKZDDao clkzdDao;
    @Autowired
    private KCZYDao kczyDao;
    @Autowired
    private ZDDKDao zddkDao;
    @Autowired
    private EnvContext envContext;
    @Autowired
    private GISManager gisManager;
    @Autowired
    DocumentService documentService;

    public Page getLedgerPages(int start, int limit, Map<String, ?> condition, String type) {
        assert (type != null);
        if (type.equals(EnumUtils.LedgerType.JCTB.getLtype())) {
            return this.jctbDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.XFQKB.getLtype())) {
            return this.xfqkbDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.WFYD.getLtype())) {
            return this.wfydDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.HYDK.getLtype())) {
            return this.hydkDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.LBGD.getLtype())) {
            return this.lbgdDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.GDDK.getLtype())) {
            return this.gddkDao.getGddkPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.CLKZD.getLtype())) {
            return this.clkzdDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.KCZY.getLtype())) {
            return this.kczyDao.getPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.DJDK.getLtype())) {
            return this.gddkDao.getDJDKPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.ZDDK.getLtype())) {
            return this.zddkDao.getZDDKPages(start, limit, condition);
        }
        if (type.equals(EnumUtils.LedgerType.XXGK.getLtype())) {
            return this.xxgksqsDao.getXXGKSQSPages(start, limit, condition);
        }
        throw new RuntimeException(this.getMessage("type.not.supported", new Object[]{type}));
    }

    public List getLedgerEntities(Map<String, ?> condition, String type) {
        assert (type != null);
        if (type.equals(EnumUtils.LedgerType.JCTB.getLtype())) {
            return this.jctbDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.XFQKB.getLtype())) {
            return this.xfqkbDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.WFYD.getLtype())) {
            return this.wfydDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.HYDK.getLtype())) {
            return this.hydkDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.LBGD.getLtype())) {
            return this.lbgdDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.GDDK.getLtype())) {
            return this.gddkDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.CLKZD.getLtype())) {
            return this.clkzdDao.getEntities(condition);
        }
        if (type.equals(EnumUtils.LedgerType.KCZY.getLtype())) {
            return this.kczyDao.getEntities(condition);
        }
        throw new RuntimeException(this.getMessage("type.not.supported", new Object[]{type}));
    }

    public Xfqkb findXfqkb(String id) {
        return (Xfqkb)this.xfqkbDao.find((Serializable)((Object)id));
    }

    public Xxgksqs findXxgksqs(String id) {
        return (Xxgksqs)this.xxgksqsDao.find((Serializable)((Object)id));
    }

    public boolean update(Object obj, String type) {
        boolean success = false;
        Map<String, String> map = new HashMap<String, Object>();
        try {
            if (type.equals(EnumUtils.LedgerType.HYDK.getLtype())) {
                HYDK hydk = (HYDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.hydk.layer"));
                if (!this.isNull((Object)hydk.getTdzh())) {
                    map.put("TDZH", hydk.getTdzh());
                    success = this.gisManager.getGISService().update(layerName, hydk.getObjectId(), map, null);
                }
            } else if (type.equals(EnumUtils.LedgerType.WFYD.getLtype())) {
                WFYD wfyd = (WFYD)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.wfyd.layer"));
                if (!this.isNull((Object)wfyd.getSfxc())) {
                    map.put("SFXC", (String)((Object)Integer.valueOf(wfyd.getSfxc())));
                    success = this.gisManager.getGISService().update(layerName, wfyd.getObjectId(), map, null);
                }
            } else if (type.equals(EnumUtils.LedgerType.GDDK.getLtype())) {
                GDDK gddk = (GDDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.gddk.layer"));
                map = gddk.toMap();
                success = this.gisManager.getGISService().update(layerName, gddk.getObjectId(), map, null);
            } else if (type.equals(EnumUtils.LedgerType.DJDK.getLtype())) {
                DJDK djdk = (DJDK)obj;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String layerName = String.valueOf(this.envContext.getEnv("sde.djdk.layer"));
                map.put("DYLX", djdk.getDylx());
                map.put("DYDQSJ", simpleDateFormat.format(djdk.getDydqsj()));
                success = this.gisManager.getGISService().update(layerName, djdk.getObjectId(), map, null);
            } else if (type.equals(EnumUtils.LedgerType.CLKZD.getLtype())) {
                CLKZD clkzd = (CLKZD)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.clkzd.layer"));
                map.put("XCJL", clkzd.getXcjl());
                map.put("CLBZQK", clkzd.getClbzqk());
                success = this.gisManager.getGISService().update(layerName, clkzd.getObjectId(), map, null);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }

    public boolean delete(String proid, String type) {
        boolean success = false;
        try {
            if (type.equals(EnumUtils.LedgerType.XFQKB.getLtype())) {
                this.xfqkbDao.delete((Serializable)((Object)proid));
            } else if (type.equals(EnumUtils.LedgerType.XXGK.getLtype())) {
                this.xxgksqsDao.delete((Serializable)((Object)proid));
            }
            success = true;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document exportExcel(String type, String startTime, String endTime) {
        String[] time;
        assert (type != null);
        List datas = null;
        Document document = null;
        String tplName = type.concat(".xml");
        HashMap<String, Object> info = new HashMap<String, Object>();
        HashMap condition = new HashMap();
        ArrayList<String> lists = new ArrayList<String>();
        GregorianCalendar calendar = new GregorianCalendar();
        if (!"".equals(startTime) && !"".equals(endTime)) {
            lists.add("(sfsj> to_date('" + startTime + "','yyyy-MM-dd') and sfsj<to_date('" + endTime + "','yyyy-MM-dd'))");
            time = endTime.split("-");
            info.put("top_year", time[0]);
            info.put("top_month", time[1]);
        } else if ("".equals(startTime) && "".equals(endTime)) {
            startTime = calendar.get(1) + "-" + calendar.get(2) + "-" + 20;
            endTime = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + 20;
            lists.add("(sfsj> to_date('" + startTime + "','yyyy-MM-dd') and sfsj<to_date('" + endTime + "','yyyy-MM-dd'))");
            info.put("top_year", String.valueOf(calendar.get(1)));
            info.put("top_month", String.valueOf(calendar.get(2)));
        } else if (!"".equals(startTime)) {
            time = startTime.split("-");
            endTime = time[0] + "-" + (Integer.parseInt(time[1]) + 1) + "-" + 20;
            lists.add("(sfsj> to_date('" + startTime + "','yyyy-MM-dd') and sfsj<to_date('" + endTime + "','yyyy-MM-dd'))");
            info.put("top_year", time[0]);
            info.put("top_month", String.valueOf(Integer.parseInt(time[1]) + 1));
        } else if (!"".equals(endTime)) {
            time = endTime.split("-");
            startTime = time[0] + "-" + (Integer.parseInt(time[1]) - 1) + "-" + 20;
            lists.add("(sfsj> to_date('" + startTime + "','yyyy-MM-dd') and sfsj<to_date('" + endTime + "','yyyy-MM-dd'))");
            info.put("top_year", time[0]);
            info.put("top_month", time[1]);
        }
        condition.put("condition", lists);
        if (type.equals(EnumUtils.LedgerType.JCTB.getLtype())) {
            datas = this.jctbDao.getEntities(condition);
            info.put("jctbs", datas);
        } else if (type.equals(EnumUtils.LedgerType.XFQKB.getLtype())) {
            datas = this.xfqkbDao.getEntities(condition);
            info.put("xfqkbs", datas);
        } else if (type.equals(EnumUtils.LedgerType.WFYD.getLtype())) {
            datas = this.wfydDao.getEntities(condition);
            info.put("wfyds", datas);
        } else if (type.equals(EnumUtils.LedgerType.HYDK.getLtype())) {
            datas = this.hydkDao.getEntities(condition);
            info.put("hydks", datas);
        } else {
            if (!type.equals(EnumUtils.LedgerType.LBGD.getLtype())) throw new RuntimeException("type is not found!");
            datas = this.lbgdDao.getEntities(condition);
            info.put("lbgds", datas);
        }
        info.put("year", String.valueOf(calendar.get(1)));
        info.put("month", String.valueOf(calendar.get(2) + 1));
        info.put("day", String.valueOf(calendar.get(5)));
        try {
            document = this.documentService.renderExcel(info, tplName);
            document.setType(Document.Type.xls);
            if (type.equals(EnumUtils.LedgerType.XFQKB.getLtype())) {
                document.setName("\u4fe1\u8bbf\u60c5\u51b5\u7edf\u8ba1\u8868");
                return document;
            }
            if (!type.equals(EnumUtils.LedgerType.JCTB.getLtype()) && !type.equals(EnumUtils.LedgerType.WFYD.getLtype()) && !type.equals(EnumUtils.LedgerType.HYDK.getLtype()) && !type.equals(EnumUtils.LedgerType.LBGD.getLtype())) return document;
        }
        catch (Exception e) {
            this.logger.error("excel\u6e32\u67d3\u9519\u8bef" + e.getMessage());
            e.printStackTrace();
        }
        return document;
    }

    public Map<String, List> getExcelMap(List entities, String type) {
        assert (type != null);
        HashMap<String, List> result = new HashMap<String, List>();
        if (type.equals(EnumUtils.LedgerType.JCTB.getLtype())) {
            ArrayList sheet1 = new ArrayList();
            ArrayList sheet2 = new ArrayList();
            for (int i = 0; i < entities.size(); ++i) {
                ArrayList<Object> list1 = new ArrayList<Object>();
                ArrayList<Object> list2 = new ArrayList<Object>();
                JCTB jctb = (JCTB)entities.get(i);
                list1.add(i + 1);
                list1.add(jctb.getJcbh());
                list1.add(jctb.getJcmj());
                list1.add(jctb.getTblx());
                list1.add(jctb.getDlyt());
                list1.add(jctb.getBgfw());
                list2.add(i + 1);
                list2.add(jctb.getJcbh());
                list2.add(jctb.getTblx());
                list2.add(jctb.getDlkd());
                list2.add(jctb.getJcmj());
                list2.add(jctb.getBz());
                sheet1.add(list1);
                sheet2.add(list2);
            }
            if (sheet1.size() > 0) {
                result.put("sheet1", sheet1);
            }
            if (sheet2.size() > 0) {
                result.put("sheet2", sheet2);
            }
        }
        return result;
    }

    public List<Map> getExcelList(List entities, String type) {
        return null;
    }
}

