/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.entity.Document;
import com.gtis.emapserver.service.DocumentService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.service.impl.DocumentServiceImpl;
import com.gtis.emapserver.utils.AppPropertyUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentServiceImpl
extends BaseLogger
implements DocumentService {
    private static final String START_MARK = "[$]";
    private String location;
    private Configuration cfg;

    public Document writeExcel(Map<String, List> data, String tplName) throws Exception {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            for (Map.Entry<String, List> entry : data.entrySet()) {
                String sheetName = entry.getKey();
                List values = entry.getValue();
                Sheet sheet = workbook.getSheet(sheetName);
                if (this.isNull((Object)sheet)) {
                    throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[]{sheetName}));
                }
                int rowIndex = -1;
                CellStyle cellStyle = null;
                for (Row row : sheet) {
                    Cell start = row.getCell(0);
                    if (this.isNull((Object)start) || !START_MARK.equals(start.getStringCellValue())) continue;
                    rowIndex = start.getRowIndex();
                    cellStyle = start.getCellStyle();
                    break;
                }
                if (rowIndex == -1) {
                    throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
                }
                Row row = null;
                Cell cell = null;
                for (int i = 0; i < values.size(); ++i) {
                    row = sheet.createRow(i + rowIndex);
                    List columns = (List)values.get(i);
                    for (int cIndex = 0; cIndex < columns.size(); ++cIndex) {
                        cell = row.createCell(cIndex);
                        cell.setCellStyle(cellStyle);
                        Object value = columns.get(cIndex);
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                            continue;
                        }
                        cell.setCellValue(String.valueOf(value));
                    }
                }
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.write((OutputStream)out);
                document.setContent(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return document;
    }

    public Document writeExcel(List<Map> data) throws Exception {
        Document document = "old".equals(AppPropertyUtils.getAppEnv((String)"office.plugin.version")) ? new Document(Tag.result.name(), Document.Type.xls) : new Document(Tag.result.name(), Document.Type.xlsx);
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (Map item : data) {
            String sheetName = this.isNull(item.get(Tag.name.name())) ? "Sheet" + data.indexOf(item) : String.valueOf(item.get(Tag.name.name()));
            Sheet sheet = workbook.createSheet(sheetName);
            Row row = sheet.createRow(0);
            List header = (List)item.get(Tag.header.name());
            for (int i = 0; i < header.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue((String)header.get(i));
            }
            List values = (List)item.get(Tag.data.name());
            for (int rowIndex = 0; rowIndex < values.size(); ++rowIndex) {
                row = sheet.createRow(rowIndex + 1);
                List value = (List)values.get(rowIndex);
                for (int colIndex = 0; colIndex < value.size(); ++colIndex) {
                    Cell cell = row.createCell(colIndex);
                    cell.setCellValue(String.valueOf(value.get(colIndex)));
                }
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            document.setContent(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
        }
        return document;
    }

    public Document renderExcel(Object data, String tplName) throws Exception {
        Document document = Document.getDocByName((String)tplName);
        String content = this.getTpl(data, tplName);
        document.setContent(content.getBytes("UTF-8"));
        document.setType(Document.Type.xls);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTpl(Object value, String tplName) throws IOException, TemplateException {
        this.cfg = new Configuration();
        this.cfg.setEncoding(Locale.getDefault(), "UTF-8");
        this.cfg.setTemplateUpdateDelay(60);
        try {
            this.cfg.setDirectoryForTemplateLoading(this.getDocPath().getFile());
        }
        catch (IOException e) {
            this.logger.error("\u6e32\u67d3\u6a21\u7248\u8def\u5f84\u5b58\u5728\u5f02\u5e38\uff1a", (Object)e.getLocalizedMessage());
        }
        Template tpl = this.cfg.getTemplate(tplName, "utf-8");
        StringWriter writer = new StringWriter();
        try {
            tpl.process(value, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            writer.close();
        }
        return "";
    }

    private InputStream getExcel(Document doc) throws IOException {
        try {
            return this.getDocResorce(doc.getFileName()).getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.not.found", new Object[]{doc.getFileName()}));
        }
    }

    private Resource getDocResorce(String docName) throws MalformedURLException {
        return new UrlResource(this.location.concat(docName));
    }

    private Resource getDocPath() {
        try {
            return new UrlResource(this.location);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

