/*
 * Decompiled with CFR 0.152.
 */
package com.gits.etl.web;

import com.gits.etl.service.JobManager;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected JobManager jobManager;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"), true));
    }

    @ExceptionHandler(value={Exception.class})
    public String handleException(Exception ex, HttpServletRequest request) {
        this.logger.debug("handle exception from request [" + request.getPathInfo() + "]", (Throwable)ex);
        request.setAttribute("ex", (Object)ex);
        return "error";
    }

    protected Model success(Model model) {
        return model.addAttribute("ret", (Object)0);
    }

    protected Model failed(Model model, String msg) {
        model.addAttribute("msg", (Object)msg);
        return model.addAttribute("ret", (Object)1);
    }
}

