/*
 * Decompiled with CFR 0.152.
 */
package com.gits.etl.model;

import com.alibaba.fastjson.JSON;
import com.gits.etl.model.JobReport;
import com.gits.etl.util.BeanAccessor;
import com.gits.etl.util.DirectBeanAccessor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInstance {
    protected final Log LOG = LogFactory.getLog(JobInstance.class);
    private Object job;
    private BeanAccessor jobAccessor;
    private JobReport report;

    public JobInstance(Object job) {
        this.job = job;
        this.jobAccessor = new DirectBeanAccessor(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runJob(Map<String, String> params) {
        Object[] args = new String[params.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            args[i++] = "--context_param";
            args[i++] = entry.getKey() + "=" + entry.getValue();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Job param" + Arrays.toString(args)));
        }
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.job.getClass().getClassLoader());
            Integer ret = (Integer)this.jobAccessor.invoke("runJobInTOS", new Object[]{args});
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Job " + this.getJobName() + " finished, return code is " + ret));
            }
            int n = ret;
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }

    public String getJobName() {
        return (String)this.jobAccessor.getFieldValue("jobName");
    }

    public String getJobVersion() {
        return (String)this.jobAccessor.getFieldValue("jobVersion");
    }

    public String getProjectName() {
        return (String)this.jobAccessor.getFieldValue("projectName");
    }

    public String getContextStr() {
        return (String)this.jobAccessor.getFieldValue("contextStr");
    }

    public Properties getContext() {
        return (Properties)this.jobAccessor.invoke("getContext", new Object[0]);
    }

    public String getErrorMessage() {
        return (String)this.jobAccessor.invoke("getExceptionStackTrace", new Object[0]);
    }

    public Map<String, Long> getStartHash() {
        return (Map)this.jobAccessor.getFieldValue("start_Hash");
    }

    public Map<String, Long> getEndHash() {
        return (Map)this.jobAccessor.getFieldValue("end_Hash");
    }

    public Map<String, Boolean> getOkHash() {
        return (Map)this.jobAccessor.getFieldValue("ok_Hash");
    }

    public Map<String, Object> getGlobalMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map globalMap = (Map)this.jobAccessor.getFieldValue("globalMap");
        for (Map.Entry entry : globalMap.entrySet()) {
            Object obj = entry.getValue();
            if (!(obj instanceof Serializable)) continue;
            map.put((String)entry.getKey(), obj);
        }
        return map;
    }

    public JobReport getReport() {
        return this.report;
    }

    public void setReport(JobReport report) {
        this.report = report;
    }

    public String getDetail() {
        LinkedHashMap<String, Map> detail = new LinkedHashMap<String, Map>();
        detail.put("global", this.getGlobalMap());
        detail.put("ok", this.getOkHash());
        detail.put("end", this.getEndHash());
        detail.put("start", this.getStartHash());
        return JSON.toJSONString(detail);
    }
}

