/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.ibatis;

import com.gtis.sql.dialect.Dialect;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SplitSqlExecutor
extends SqlExecutor {
    private static final Log logger = LogFactory.getLog(SplitSqlExecutor.class);
    private Dialect dialect;
    private boolean enableLimit = true;

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public boolean isEnableLimit() {
        return this.enableLimit;
    }

    public void setEnableLimit(boolean enableLimit) {
        this.enableLimit = enableLimit;
    }

    public boolean supportsLimit() {
        if (this.enableLimit && this.dialect != null) {
            return this.dialect.supportsLimit();
        }
        return false;
    }

    public void executeQuery(StatementScope stateScope, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        if ((skipResults != 0 || maxResults != -999999) && this.supportsLimit()) {
            sql = this.dialect.getLimitString(sql, skipResults, maxResults);
            logger.debug((Object)sql);
            skipResults = 0;
            maxResults = -999999;
        }
        super.executeQuery(stateScope, conn, sql, parameters, skipResults, maxResults, callback);
    }
}

