/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.security;

import com.gtis.generic.security.EgovServiceProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.cas.ServiceProperties;
import org.springframework.util.Assert;

public class EgovCasProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private String loginUrl;
    private ServiceProperties serviceProperties;
    private boolean encodeServiceUrlWithSessionId = true;
    private boolean useRelativeContext = false;

    public void commence(ServletRequest servletRequest, ServletResponse servletResponse, AuthenticationException authException) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestServerName = request.getServerName();
        EgovServiceProperties egovServiceProperties = (EgovServiceProperties)this.serviceProperties;
        String egovServiceUrl = egovServiceProperties.getServiceMap().containsKey(requestServerName) ? egovServiceProperties.getServiceByIp(requestServerName) : egovServiceProperties.getService();
        String urlEncodedService = CommonUtils.constructServiceUrl(null, (HttpServletResponse)response, (String)(this.useRelativeContext ? this.handleRelativeContext(request, egovServiceUrl) : egovServiceUrl), null, (String)"ticket", (boolean)this.encodeServiceUrlWithSessionId);
        String redirectUrl = CommonUtils.constructRedirectUrl((String)(this.useRelativeContext ? this.handleRelativeContext(request, this.getLoginUrl()) : this.getLoginUrl()), (String)"service", (String)urlEncodedService, (boolean)this.serviceProperties.isSendRenew(), (boolean)false);
        response.sendRedirect(redirectUrl);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.loginUrl, (String)"loginUrl must be specified");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties must be specified");
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public boolean isEncodeServiceUrlWithSessionId() {
        return this.encodeServiceUrlWithSessionId;
    }

    public void setEncodeServiceUrlWithSessionId(boolean encodeServiceUrlWithSessionId) {
        this.encodeServiceUrlWithSessionId = encodeServiceUrlWithSessionId;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public boolean isUseRelativeContext() {
        return this.useRelativeContext;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }

    private String handleRelativeContext(HttpServletRequest request, String absoluteUrl) throws MalformedURLException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(request.isSecure() ? "https://" : "http://");
        urlBuilder.append(request.getServerName());
        urlBuilder.append(":");
        urlBuilder.append(request.getServerPort());
        URL url = new URL(absoluteUrl);
        urlBuilder.append(url.getPath());
        return urlBuilder.toString();
    }
}

