package com.gtis.spring;

import com.gtis.config.EgovConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * war部署成功后所使用的监听器,framework2.0版本的标准做法
 *
 * @author shengw
 */
public final class SpringListenerImpl implements ServletContextListener {

    private static final Logger logger = LoggerFactory.getLogger(SpringListenerImpl.class);

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            EgovConfigLoader.load();
            Container.createApplicationContext(sce.getServletContext());
            logger.info("Spring applicationContext create success");
        } catch (RuntimeException e) {
            e.printStackTrace();
            logger.error("Spring applicationContext create fail", e);
        }
    }

}
