/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: ImageUtils.java
 *
 * LastModified: 2009-08-15 11:21:16
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.util;

import com.gtis.generic.image.ImageTransform;
import com.gtis.generic.image.ImageTransformFactory;

/**
 * 图像处理工具类.
 *
 * @author hzzhu
 * @version 1.0
 */
public class ImageUtils {

    /**
     * use imageTransform to resize,rotate image.
     *
     * @param srcFilePath  源文件路径,eg D:\\ccs\\web\\upload_images\\original\\1.jpg
     * @param destFilePath 目标文件路径,eg D:\\ccs\\web\\upload_images\\big\\1.jpg
     * @param width        宽度
     * @param height       高度
     * @throws Exception Exception
     */
    public static void resizeImage(String srcFilePath, String destFilePath, int width, int height) throws Exception {
        ImageTransform it = ImageTransformFactory.getImageTransform();

        it.load(srcFilePath);
        it.resize(width, height);
        it.save(destFilePath);
    }

    public static void resizeImageWithMaxWidth(String srcFilePath, String destFilePath, int maxWidth) throws Exception {
        ImageTransform it = ImageTransformFactory.getImageTransform();

        it.load(srcFilePath);
        it.resizeWithMaxWidth(maxWidth);
        it.save(destFilePath);
    }

    public static void rotateImageWithMaxWidth(String srcFilePath, String destFilePath, double rotate, int maxWidth)
            throws Exception {
        ImageTransform it = ImageTransformFactory.getImageTransform();

        it.load(srcFilePath);
        it.rotateWithMaxWidth(rotate, maxWidth);
        it.save(destFilePath);
    }

    public static void rotateImage(String srcFilePath, String destFilePath, double rotate) throws Exception {
        ImageTransform it = ImageTransformFactory.getImageTransform();

        it.load(srcFilePath);
        it.rotate(rotate);
        it.save(destFilePath);
    }
    /*
     * public static void main(String[] ss) throws Exception {
     *   resizeImageWithMaxWidth("1.jpg", "2.png", 200);
     *   rotateImageWithMaxWidth("1.jpg", "3.png", 90.0, 200);
     *   rotateImageWithMaxWidth("1.jpg", "4.png", -90.0, 200);
     * }
     */
}
