package com.gtis.generic.security;

import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.cas.ServiceProperties;
import org.springframework.util.Assert;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/12/14
 */
public class EgovCasProcessingFilterEntryPoint implements AuthenticationEntryPoint, InitializingBean {

    private String loginUrl;

    private ServiceProperties serviceProperties;

    private boolean encodeServiceUrlWithSessionId = true;

    private boolean useRelativeContext = false;

    @Override
    public void commence(ServletRequest servletRequest, ServletResponse servletResponse, AuthenticationException authException) throws IOException, ServletException {
        final HttpServletResponse response = (HttpServletResponse) servletResponse;
        final HttpServletRequest request = (HttpServletRequest) servletRequest;
        String requestServerName = request.getServerName();
        EgovServiceProperties egovServiceProperties = (EgovServiceProperties)serviceProperties;
        final String egovServiceUrl = egovServiceProperties.getServiceMap().containsKey(requestServerName)?egovServiceProperties.getServiceByIp(requestServerName):egovServiceProperties.getService();
        final String urlEncodedService = CommonUtils.constructServiceUrl(null, response, useRelativeContext?handleRelativeContext(request,egovServiceUrl):egovServiceUrl, null, "ticket", this.encodeServiceUrlWithSessionId);
        final String redirectUrl = CommonUtils.constructRedirectUrl(useRelativeContext?handleRelativeContext(request,this.getLoginUrl()):this.getLoginUrl(), "service", urlEncodedService, this.serviceProperties.isSendRenew(), false);
        response.sendRedirect(redirectUrl);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasLength(this.loginUrl, "loginUrl must be specified");
        Assert.notNull(this.serviceProperties, "serviceProperties must be specified");
    }

    public ServiceProperties getServiceProperties() {
        return serviceProperties;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public boolean isEncodeServiceUrlWithSessionId() {
        return encodeServiceUrlWithSessionId;
    }

    public void setEncodeServiceUrlWithSessionId(boolean encodeServiceUrlWithSessionId) {
        this.encodeServiceUrlWithSessionId = encodeServiceUrlWithSessionId;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public boolean isUseRelativeContext() {
        return useRelativeContext;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }

    private String handleRelativeContext(HttpServletRequest request,final String absoluteUrl) throws MalformedURLException {
        final StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(request.isSecure() ? "https://" : "http://");
        urlBuilder.append(request.getServerName());
        urlBuilder.append(":");
        urlBuilder.append(request.getServerPort());
        final URL url = new URL(absoluteUrl);
        urlBuilder.append(url.getPath());
        return urlBuilder.toString();
    }
}
