/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MagickCommandImageTransform.java
 *
 * LastModified: 2009-09-23 06:06:26
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.image.impl;


import com.gtis.generic.image.ImageTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-8 14:11:27
 */
public class MagickCommandImageTransform implements ImageTransform {

    private static final Logger logger = LoggerFactory.getLogger(AwtImageTransform.class);
    private String srcFilePath;
    private double srcWidth;
    private double srcHeight;
    private double destRotate = 0L;
    private double destRatio = 1L;
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;

    public boolean load(String srcFilePath) {
        try {
            BufferedImage srcBImage = ImageIO.read(new java.io.File(srcFilePath));
            this.srcFilePath = srcFilePath;
            srcWidth = srcBImage.getWidth();
            srcHeight = srcBImage.getHeight();
        } catch (IOException e) {
            logger.info("Cannot open image [{}]", srcFilePath);
            return false;
        }
        return true;
    }

    public boolean save(String destFilePath) {
        StringBuffer cmd = new StringBuffer();
        if (isWindows)
            cmd.append("cmd /c ");
        cmd.append("convert ");
        if (destRotate != 0L) {
            cmd.append("-rotate ").append(destRotate).append(" ");
        }
        if (destRatio != 1L) {
            cmd.append("-sample ").append(destRatio * srcWidth).append("x").append(destRatio * srcHeight).append(" ");
        }
        cmd.append(srcFilePath).append(" ").append(destFilePath);
        logger.debug(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int exitVal = proc.waitFor();
            if (exitVal != 0)
                return false;
        } catch (Exception e) {
            logger.error("Error exec magick convert command [" + cmd + "]", e);
        }
        return true;
    }

    public void resize(int width, int height) throws Exception {
        double xRatio = (double) height / this.srcHeight;
        double yRatio = (double) width / this.srcWidth;
        destRatio = (xRatio < yRatio) ? xRatio : yRatio;
    }

    public void rotate(double rotate) throws Exception {
        destRotate = rotate;
    }

    public void resizeWithMaxWidth(int maxWidth) throws Exception {
        if (srcWidth > maxWidth)
            destRatio = (double) maxWidth / srcWidth;
    }

    public void rotateWithMaxWidth(double rotate, int maxWidth) throws Exception {
        rotate(rotate);
        resizeWithMaxWidth(maxWidth);
    }
}
