/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.DataFetcher;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseDataFetcher
implements DataFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseDataFetcher.class);
    protected JdbcTemplate jdbcTemplate;
    protected String sql;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean hasDataSource() {
        return this.jdbcTemplate != null;
    }

    @Override
    public Map<String, Object> fetchData(String id) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map map = null;
        try {
            map = this.jdbcTemplate.queryForMap(this.sql, this.getParams(id));
        }
        catch (DataAccessException e) {
            LOG.debug("Fetch date error:[{}]", (Object)e.getMessage());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                dataMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
        }
        return dataMap;
    }

    @Override
    public String getDescription() {
        return this.getClass() + " sql:[" + this.sql + "]";
    }

    protected Object[] getParams(String id) {
        return new Object[]{id};
    }
}

